/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowEmptyStateKt;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactory;
import com.intellij.openapi.vcs.merge.MergeConflictManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CommitToolWindowFactory;", "Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "<init>", "()V", "init", "", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "setEmptyState", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/util/ui/StatusText;", "isAvailable", "", "createToolWindowContent", "toolWindow", "updateState", "intellij.platform.vcs.impl"})
public final class CommitToolWindowFactory
extends VcsToolWindowFactory {
    @Override
    public void init(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super.init(window);
        AnAction anAction = ActionManager.getInstance().getAction("CommitView.GearActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        window.setAdditionalGearActions((ActionGroup)anAction);
    }

    @Override
    protected void setEmptyState(@NotNull Project project, @NotNull StatusText state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        VcsToolWindowEmptyStateKt.setCommitViewEmptyState(state, project);
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return VcsToolWindowFactory.Companion.canBeAvailableInProject(project) && ProjectLevelVcsManager.Companion.getInstance(project).hasAnyMappings() && ChangesViewContentManager.Companion.isCommitToolWindowShown(project);
    }

    @Override
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.createToolWindowContent(project, toolWindow);
        VcsToolWindowEmptyStateKt.hideCommitIdLabelIfNotEmptyState(toolWindow);
        if (toolWindow.getContentManager().isEmpty()) {
            ToolWindowEmptyStateAction.rebuildContentUi((ToolWindow)toolWindow);
        }
    }

    @Override
    protected void updateState(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.updateState(toolWindow);
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!toolWindow.isAvailable() || !MergeConflictManager.Companion.isNonModalMergeEnabled(project2)) {
            return;
        }
        if (!MergeConflictManager.Companion.getInstance(project2).isMergeConflict()) {
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowCommit);
        } else {
            Color focusColor = UIManager.getColor("ToolWindow.Button.selectedForeground");
            Icon originalIcon = toolWindow.getIcon();
            if (originalIcon != null) {
                JBColor badgeColor = new JBColor(() -> CommitToolWindowFactory.updateState$lambda$0(toolWindow, focusColor));
                Icon badgeIcon = IconManager.Companion.getInstance().withIconBadge(originalIcon, (Paint)badgeColor);
                toolWindow.setIcon(badgeIcon);
            }
        }
    }

    private static final Color updateState$lambda$0(ToolWindow $toolWindow, Color $focusColor) {
        return $toolWindow.isActive() ? $focusColor : JBUI.CurrentTheme.IconBadge.ERROR;
    }
}

