/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.HistoryTestRunnableState;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImportedTestRunnableState
implements RunProfileState,
HistoryTestRunnableState {
    private final AbstractImportTestsAction.ImportRunProfile myRunProfile;
    private final File myFile;

    public ImportedTestRunnableState(AbstractImportTestsAction.ImportRunProfile profile, File file) {
        this.myRunProfile = profile;
        this.myFile = file;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) {
        String frameworkName;
        SMTRunnerConsoleProperties properties;
        Object configuration;
        if (runner == null) {
            ImportedTestRunnableState.$$$reportNull$$$0(0);
        }
        MyEmptyProcessHandler handler = new MyEmptyProcessHandler();
        RunConfiguration initialConfiguration = this.myRunProfile.getInitialConfiguration();
        if (initialConfiguration instanceof SMRunnerConsolePropertiesProvider) {
            configuration = initialConfiguration;
            properties = ((SMRunnerConsolePropertiesProvider)configuration).createTestConsoleProperties(DefaultRunExecutor.getRunExecutorInstance());
            frameworkName = properties.getTestFrameworkName();
        } else {
            configuration = this.myRunProfile;
            properties = null;
            frameworkName = "Import Test Results";
        }
        ImportedTestConsoleProperties consoleProperties = new ImportedTestConsoleProperties(properties, this.myFile, handler, this.myRunProfile.getProject(), (RunProfile)configuration, frameworkName, executor);
        if (properties != null) {
            Disposer.register((Disposable)consoleProperties, (Disposable)properties);
        }
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(consoleProperties.getTestFrameworkName(), consoleProperties);
        JComponent component = console.getComponent();
        AbstractRerunFailedTestsAction rerunFailedTestsAction = null;
        if (component instanceof TestFrameworkRunningModel && (rerunFailedTestsAction = consoleProperties.createRerunFailedTestsAction((ConsoleView)console)) != null) {
            rerunFailedTestsAction.setModelProvider(() -> (TestFrameworkRunningModel)component);
        }
        console.attachToProcess((ProcessHandler)handler);
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)handler);
        if (rerunFailedTestsAction != null) {
            result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/testframework/sm/runner/history/ImportedTestRunnableState", "execute"));
    }

    private static class MyEmptyProcessHandler
    extends ProcessHandler {
        private MyEmptyProcessHandler() {
        }

        protected void destroyProcessImpl() {
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(0);
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

