/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsFromHistoryAction
extends AbstractImportTestsAction {
    private final String myFileName;

    public ImportTestsFromHistoryAction(Project project, String name) {
        this(project, name, null);
    }

    public ImportTestsFromHistoryAction(Project project, String name, @Nullable Executor executor) {
        super(StringUtil.escapeMnemonics((String)ImportTestsFromHistoryAction.getPresentableText(project, name)), ImportTestsFromHistoryAction.getPresentableText(project, name), ImportTestsFromHistoryAction.getIcon(project, name), executor);
        this.myFileName = name;
    }

    private static Icon getIcon(Project project, String name) {
        return TestHistoryConfiguration.getInstance(project).getIcon(name);
    }

    @NotNull
    @NlsSafe
    private static String getPresentableText(Project project, String name) {
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)name);
        int lastIndexOf = nameWithoutExtension.lastIndexOf(" - ");
        if (lastIndexOf > 0) {
            String string;
            String date = nameWithoutExtension.substring(lastIndexOf + 3);
            try {
                Date creationDate = new SimpleDateFormat("yyyy.MM.dd 'at' HH'h' mm'm' ss's'").parse(date);
                String configurationName = TestHistoryConfiguration.getInstance(project).getConfigurationName(name);
                string = (configurationName != null ? configurationName : nameWithoutExtension.substring(0, lastIndexOf)) + " (" + DateFormatUtil.formatDateTime((Date)creationDate) + ")";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (string == null) {
                ImportTestsFromHistoryAction.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = nameWithoutExtension;
        if (string == null) {
            ImportTestsFromHistoryAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull Project project) {
        if (project == null) {
            ImportTestsFromHistoryAction.$$$reportNull$$$0(2);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(TestStateStorage.getTestHistoryRoot((Project)project).getPath() + "/" + this.myFileName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

