/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredState
extends AbstractState {
    private final String myText;
    private final String myStacktrace;

    public TestIgnoredState(@Nullable String ignoredMsg, @Nullable String stackTrace) {
        this.myText = StringUtil.isEmpty((String)ignoredMsg) ? null : "\n" + ignoredMsg + "\n";
        this.myStacktrace = stackTrace == null ? null : stackTrace + "\n";
    }

    public boolean isInProgress() {
        return false;
    }

    public boolean isDefect() {
        return true;
    }

    public boolean wasLaunched() {
        return true;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean wasTerminated() {
        return false;
    }

    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        if (this.myText != null) {
            printer.print(this.myText, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myStacktrace)) {
            printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            printer.mark();
            printer.print(this.myStacktrace, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    public String toString() {
        return "TEST IGNORED";
    }
}

