/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0006\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0017\u0010\u0017\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/lineProfiler/statistics/LineProfilerUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "choiceCount", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "navigated", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "navigationPopupOpened", "showPerformanceHints", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "hidePerformanceHints", "logNavigation", "", "project", "Lcom/intellij/openapi/project/Project;", "logNavigationPopupShow", "logShowPerformanceHints", "logHidePerformanceHints", "getDumpName", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "getGroup", "intellij.profiler.lineProfiler"})
public final class LineProfilerUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final LineProfilerUsageCollector INSTANCE = new LineProfilerUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("line.profiler", 4, null, 4, null);
    @NotNull
    private static final IntEventField choiceCount = EventFields.Int((String)"navigation_choice_count");
    @NotNull
    private static final EventId2<String, Integer> navigated = GROUP.registerEvent("navigated.via.line.marker", (EventField)EventFields.AnonymizedId, (EventField)choiceCount);
    @NotNull
    private static final EventId2<String, Integer> navigationPopupOpened = GROUP.registerEvent("navigation.popup.shown", (EventField)EventFields.AnonymizedId, (EventField)choiceCount);
    @NotNull
    private static final EventId showPerformanceHints = GROUP.registerEvent("show.performance.hints");
    @NotNull
    private static final EventId hidePerformanceHints = GROUP.registerEvent("hide.performance.hints");

    private LineProfilerUsageCollector() {
    }

    public final void logNavigation(@NotNull Project project, int choiceCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        navigated.log(project, (Object)this.getDumpName(project), (Object)choiceCount);
    }

    public static /* synthetic */ void logNavigation$default(LineProfilerUsageCollector lineProfilerUsageCollector, Project project, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        lineProfilerUsageCollector.logNavigation(project, n);
    }

    public final void logNavigationPopupShow(@NotNull Project project, int choiceCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        navigationPopupOpened.log(project, (Object)this.getDumpName(project), (Object)choiceCount);
    }

    public final void logShowPerformanceHints(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        showPerformanceHints.log(project);
    }

    public final void logHidePerformanceHints(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        hidePerformanceHints.log(project);
    }

    private final String getDumpName(Project project) {
        Content content = ProfilerToolWindowManager.Companion.getInstance(project).getCurrentTab();
        return content != null ? content.getDisplayName() : null;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }
}

