/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithUnits;
import com.intellij.profiler.lineProfiler.data.LinesGroup;
import com.intellij.profiler.lineProfiler.ui.LinesViewProviderKt;
import com.intellij.profiler.lineProfiler.ui.RedGreyMap;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\u000b\u0010\u0019\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/LinesViewProvider;", "", "lines", "Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "<init>", "(Lcom/intellij/profiler/lineProfiler/data/LinesGroup;)V", "getLines$intellij_profiler_lineProfiler", "()Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "printer", "Lcom/intellij/profiler/api/ValueMetricPrinterWithUnits;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "formatHits", "", "hits", "", "getLineText", "line", "", "getTextColor", "Ljava/awt/Color;", "isModified", "", "getBackground", "selected", "getErrorStripeColor", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.lineProfiler"})
public final class LinesViewProvider {
    @NotNull
    private final LinesGroup lines;
    @NotNull
    private final ValueMetricPrinterWithUnits printer;
    @NotNull
    private final ValueMetric metric;

    public LinesViewProvider(@NotNull LinesGroup lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.lines = lines;
        this.printer = new ValueMetricPrinterWithUnits((ValueMetricPrinter)ValueMetricPrinter.Default.INSTANCE);
        this.metric = LinesViewProviderKt.access$replaceMetric(this.lines.getMetric());
    }

    @NotNull
    public final LinesGroup getLines$intellij_profiler_lineProfiler() {
        return this.lines;
    }

    @NlsSafe
    @NotNull
    public final String formatHits(long hits) {
        return this.printer.print(this.metric, hits);
    }

    @Nullable
    public final String getLineText(int line) {
        Long l = this.lines.getTotalHits(line);
        if (l == null) {
            return null;
        }
        long hits = l;
        return this.formatHits(hits);
    }

    @Nullable
    public final Color getTextColor(int line, boolean isModified) {
        if (isModified) {
            return RedGreyMap.INSTANCE.getIgnoredForeground();
        }
        Boolean bl = this.lines.isHotLine(line);
        if (bl == null) {
            return null;
        }
        boolean isHotLine = bl;
        return isHotLine ? RedGreyMap.INSTANCE.getHotForeground() : RedGreyMap.INSTANCE.getBasicForeground();
    }

    @Nullable
    public final Color getBackground(int line, boolean selected, boolean isModified) {
        if (isModified) {
            return RedGreyMap.INSTANCE.getIgnoredBackground();
        }
        Boolean bl = this.lines.isHotLine(line);
        if (bl == null) {
            return null;
        }
        boolean isHotLine = bl;
        return isHotLine ? (selected ? RedGreyMap.INSTANCE.getHotHoverBackground() : RedGreyMap.INSTANCE.getHotBackground()) : (selected ? RedGreyMap.INSTANCE.getBasicHoverBackground() : RedGreyMap.INSTANCE.getBasicBackground());
    }

    @NotNull
    public final Color getErrorStripeColor() {
        return RedGreyMap.INSTANCE.getErrorStripeBackground();
    }
}

