/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.ProjectType;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionStub
extends AnAction
implements ActionStubBase {
    private static final Logger LOG = Logger.getInstance(ActionStub.class);
    @NotNull
    private final String className;
    @NotNull
    private final String id;
    @NotNull
    private final PluginDescriptor plugin;
    @Nullable
    private final String iconPath;
    @Nullable
    private final ProjectType projectType;
    @NotNull
    private final Supplier<Presentation> templatePresentation;
    private List<Supplier<String>> synonyms;

    public ActionStub(@NotNull String actionClass, @NotNull String id, @NotNull PluginDescriptor plugin, @Nullable String iconPath, @Nullable ProjectType projectType, @NotNull Supplier<Presentation> templatePresentation) {
        if (actionClass == null) {
            ActionStub.$$$reportNull$$$0(0);
        }
        if (id == null) {
            ActionStub.$$$reportNull$$$0(1);
        }
        if (plugin == null) {
            ActionStub.$$$reportNull$$$0(2);
        }
        if (templatePresentation == null) {
            ActionStub.$$$reportNull$$$0(3);
        }
        this.synonyms = Collections.emptyList();
        this.className = actionClass;
        LOG.assertTrue(!id.isEmpty());
        this.id = id;
        this.plugin = plugin;
        this.iconPath = iconPath;
        this.projectType = projectType;
        this.templatePresentation = templatePresentation;
    }

    public void addSynonym(@NotNull Supplier<String> text) {
        if (text == null) {
            ActionStub.$$$reportNull$$$0(4);
        }
        if (this.synonyms == Collections.emptyList()) {
            this.synonyms = new SmartList(text);
        } else {
            this.synonyms.add(text);
        }
    }

    @Override
    @NotNull
    public PluginDescriptor getPlugin() {
        PluginDescriptor pluginDescriptor = this.plugin;
        if (pluginDescriptor == null) {
            ActionStub.$$$reportNull$$$0(5);
        }
        return pluginDescriptor;
    }

    @ApiStatus.Internal
    @NotNull
    public Presentation createTemplatePresentation() {
        Presentation presentation = this.templatePresentation.get();
        if (presentation == null) {
            ActionStub.$$$reportNull$$$0(6);
        }
        return presentation;
    }

    @NotNull
    public String getClassName() {
        String string = this.className;
        if (string == null) {
            ActionStub.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            ActionStub.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public String getIconPath() {
        return this.iconPath;
    }

    @Nullable
    public ProjectType getProjectType() {
        return this.projectType;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ActionStub.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public void initAction(@NotNull AnAction targetAction) {
        if (targetAction == null) {
            ActionStub.$$$reportNull$$$0(10);
        }
        ActionStub.copyTemplatePresentation(this.getTemplatePresentation(), targetAction.getTemplatePresentation());
        targetAction.setShortcutSet(this.getShortcutSet());
        this.copyActionTextOverrides(targetAction);
        for (Supplier<String> synonym : this.synonyms) {
            targetAction.addSynonym(synonym);
        }
        if (targetAction instanceof ActionGroup && !(targetAction instanceof CustomComponentAction) && !targetAction.getTemplatePresentation().isPerformGroup()) {
            LOG.error((Throwable)new PluginException(String.format("ActionGroup should be registered using <group> tag: id=\"%s\" class=\"%s\"", this.id, targetAction.getClass().getName()), this.plugin.getPluginId()));
        }
    }

    public static void copyTemplatePresentation(@NotNull Presentation sourcePresentation, @NotNull Presentation targetPresentation) {
        if (sourcePresentation == null) {
            ActionStub.$$$reportNull$$$0(11);
        }
        if (targetPresentation == null) {
            ActionStub.$$$reportNull$$$0(12);
        }
        targetPresentation.copyUnsetTemplateProperties(sourcePresentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePresentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ActionStub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePresentation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ActionStub";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugin";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSynonym";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplatePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

