/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\u0015\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0015\u0010\u0003\u001a\u00020\u0004X\u0096\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000bR\u0017\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/diagnostic/UnhandledException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cause", "", "isInteractive", "", "<init>", "(Ljava/lang/Throwable;Z)V", "getCause", "()Ljava/lang/Throwable;", "()Z", "message", "", "getMessage", "()Ljava/lang/String;", "getLocalizedMessage", "getStackTrace", "", "Ljava/lang/StackTraceElement;", "()[Ljava/lang/StackTraceElement;", "intellij.platform.ide"})
@ApiStatus.Internal
public final class UnhandledException
extends Exception {
    @NotNull
    private final Throwable cause;
    private final boolean isInteractive;
    @Nullable
    private final String message;

    public UnhandledException(@NotNull Throwable cause, boolean isInteractive) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        super(cause);
        this.cause = cause;
        this.isInteractive = isInteractive;
        this.message = this.getCause().getMessage();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    public final boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public String getLocalizedMessage() {
        return this.getCause().getLocalizedMessage();
    }

    @Override
    @NotNull
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTraceElementArray = this.getCause().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        return stackTraceElementArray;
    }
}

