/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DynamicEditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.actionSystem.LatencyRecorder;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(EditorAction.class);
    private static final Logger HANDLER_LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actionSystem.EditorActionHandler");
    private EditorActionHandler myHandler;
    private DynamicEditorActionHandler myDynamicHandler;

    protected EditorAction(EditorActionHandler defaultHandler) {
        this.myHandler = defaultHandler;
        this.setEnabledInModalContext(true);
    }

    public final synchronized EditorActionHandler setupHandler(@NotNull EditorActionHandler newHandler) {
        if (newHandler == null) {
            EditorAction.$$$reportNull$$$0(0);
        }
        this.debugLog(newHandler, "setup EditorActionHandler");
        EditorActionHandler tmp = this.getHandler();
        this.doSetupHandler(newHandler);
        return tmp;
    }

    public final synchronized EditorActionHandler getHandler() {
        if (this.myDynamicHandler == null && this.myHandler != null) {
            this.myDynamicHandler = new DynamicEditorActionHandler(this, this.myHandler);
            this.doSetupHandler(this.myDynamicHandler);
        }
        return this.myHandler;
    }

    public synchronized void clearDynamicHandlersCache() {
        if (this.myDynamicHandler != null) {
            this.myDynamicHandler.clearCache();
        }
    }

    @Nullable
    public synchronized <T> T getHandlerOfType(@NotNull Class<T> type) {
        T result2;
        EditorActionHandler handler;
        if (type == null) {
            EditorAction.$$$reportNull$$$0(1);
        }
        if ((handler = this.getHandler()) != null && (result2 = handler.getHandlerOfType(type)) != null) {
            return result2;
        }
        DynamicEditorActionHandler dynamicHandler = this.myDynamicHandler;
        if (dynamicHandler != null && dynamicHandler != handler) {
            return ((EditorActionHandler)dynamicHandler).getHandlerOfType(type);
        }
        return null;
    }

    public synchronized void setInjectedContext(boolean worksInInjected) {
        super.setInjectedContext(worksInInjected);
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (this instanceof LatencyAwareEditorAction && editor != null) {
            String actionId = ActionManager.getInstance().getId((AnAction)this);
            InputEvent inputEvent = e.getInputEvent();
            if (actionId != null && inputEvent != null) {
                LatencyRecorder.getInstance().recordLatencyAwareAction(editor, actionId, inputEvent.getWhen());
            }
        }
        this.actionPerformed(editor, dataContext);
    }

    public final void actionPerformed(Editor editor, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        if (editor.isDisposed()) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
            LOG.error("Action " + String.valueOf((Object)this) + " invoked on a disposed editor" + (String)(file == null ? "" : " for file " + String.valueOf(file)));
            return;
        }
        EditorActionHandler handler = this.getHandler();
        if (!handler.executeInCommand(editor, dataContext)) {
            this.executeHandler(handler, editor, dataContext);
            return;
        }
        String commandName = this.getTemplatePresentation().getText();
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> this.executeHandler(handler, editor, dataContext), commandName == null ? "" : commandName, (Object)handler.getCommandGroupId(editor), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorAction.$$$reportNull$$$0(4);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (editor == null) {
            if (e.isFromContextMenu()) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setEnabled(false);
            }
        } else if (editor.isDisposed()) {
            LOG.error("Disposed editor in " + String.valueOf(dataContext) + " for " + String.valueOf((Object)this));
            presentation.setEnabled(false);
        } else if (e.getInputEvent() instanceof KeyEvent) {
            this.updateForKeyboardAccess(editor, presentation, dataContext);
        } else {
            this.update(editor, presentation, dataContext);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            EditorAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.getHandler().isEnabled(editor, null, dataContext));
    }

    public void updateForKeyboardAccess(Editor editor, Presentation presentation, DataContext dataContext) {
        this.update(editor, presentation, dataContext);
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(6);
        }
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    private void doSetupHandler(@NotNull EditorActionHandler newHandler) {
        if (newHandler == null) {
            EditorAction.$$$reportNull$$$0(7);
        }
        this.myHandler = newHandler;
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
    }

    private void executeHandler(@NotNull EditorActionHandler handler, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (handler == null) {
            EditorAction.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            EditorAction.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(10);
        }
        this.debugLog(editor, "handler started");
        handler.execute(editor, null, EditorAction.getProjectAwareDataContext(editor, dataContext));
        this.debugLog(editor, "handler finished");
    }

    private void debugLog(@NotNull Object object, @NotNull String prefix) {
        if (object == null) {
            EditorAction.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            EditorAction.$$$reportNull$$$0(12);
        }
        if (HANDLER_LOG.isDebugEnabled()) {
            HANDLER_LOG.debug(prefix + " for EditorAction " + String.valueOf(((Object)((Object)this)).getClass()) + " with " + String.valueOf(object), HANDLER_LOG.isTraceEnabled() ? new Throwable() : null);
        }
    }

    @NotNull
    private static DataContext getProjectAwareDataContext(@NotNull Editor editor, @NotNull DataContext original) {
        if (editor == null) {
            EditorAction.$$$reportNull$$$0(13);
        }
        if (original == null) {
            EditorAction.$$$reportNull$$$0(14);
        }
        if (CommonDataKeys.PROJECT.getData(original) == editor.getProject()) {
            DataContext dataContext = original;
            if (dataContext == null) {
                EditorAction.$$$reportNull$$$0(15);
            }
            return dataContext;
        }
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)original, sink -> sink.set(CommonDataKeys.PROJECT, (Object)editor.getProject()));
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(16);
        }
        return dataContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actionSystem/EditorAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actionSystem/EditorAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAwareDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOfType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSetupHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "debugLog";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAwareDataContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 15, 16 -> new IllegalStateException(string);
        };
    }
}

