/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonActionsPanel
extends JPanel {
    private final ActionToolbarPosition myPosition;
    private final ActionToolbar myToolbar;
    private final Map<Buttons, AnAction> myButtons;
    private final AnAction[] myActions;
    private EnumMap<Buttons, ShortcutSet> myCustomShortcuts;

    CommonActionsPanel(@NotNull ListenerFactory factory, @Nullable JComponent contextComponent, ActionToolbarPosition position, AnAction @Nullable [] additionalActions, @Nullable Comparator<? super AnAction> buttonComparator, @NlsContexts.Button String addName, @NlsContexts.Button String removeName, @NlsContexts.Button String moveUpName, @NlsContexts.Button String moveDownName, @NlsContexts.Button String editName, Icon addIcon, Buttons ... buttons) {
        int i;
        if (factory == null) {
            CommonActionsPanel.$$$reportNull$$$0(0);
        }
        if (buttons == null) {
            CommonActionsPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myButtons = new HashMap<Buttons, AnAction>();
        this.myPosition = position;
        Listener listener2 = factory.createListener(this);
        AnAction[] actions = new AnAction[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i = 0; i < buttons.length; ++i) {
            AnAction[] button2 = buttons[i];
            String name = switch (button2.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> addName;
                case 2 -> editName;
                case 1 -> removeName;
                case 3 -> moveUpName;
                case 4 -> moveDownName;
            };
            AnActionButton b = button2.createButton(listener2, name, button2 == Buttons.ADD && addIcon != null ? addIcon : button2.getIcon());
            actions[i] = b;
            this.myButtons.put((Buttons)button2, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i = buttons.length;
            for (AnAction button3 : additionalActions) {
                actions[i++] = button3;
            }
        }
        this.myActions = actions;
        for (AnAction action : actions) {
            if (!(action instanceof AnActionButton)) continue;
            AnActionButton anActionButton = (AnActionButton)action;
            anActionButton.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        AnAction[] toolbarActions = (AnAction[])actions.clone();
        for (int i2 = 0; i2 < toolbarActions.length; ++i2) {
            if (!(toolbarActions[i2] instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions[i2] = ((AnActionButton.CheckedAnActionButton)toolbarActions[i2]).getDelegate();
        }
        ActionManager actionManager = ActionManager.getInstance();
        this.myToolbar = actionManager.createActionToolbar("ToolbarDecorator", (ActionGroup)new DefaultActionGroup(toolbarActions), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP);
        this.myToolbar.setTargetComponent(contextComponent);
        this.myToolbar.getComponent().setBorder(null);
        this.add((Component)this.myToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            CommonActionsPanel.$$$reportNull$$$0(2);
        }
        return actionToolbar;
    }

    public void setToolbarLabel(JComponent label2, ActionToolbarPosition position) {
        this.removeAll();
        this.add((Component)label2, ToolbarDecorator.getPlacement(position));
        if (position == ActionToolbarPosition.LEFT) {
            this.add((Component)this.myToolbar.getComponent(), "East");
        } else if (position == ActionToolbarPosition.RIGHT) {
            this.add((Component)this.myToolbar.getComponent(), "West");
        } else {
            this.add((Component)this.myToolbar.getComponent(), "Center");
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @Nullable
    public AnActionButton getAnActionButton(@NotNull Buttons button2) {
        if (button2 == null) {
            CommonActionsPanel.$$$reportNull$$$0(3);
        }
        return (AnActionButton)((Object)ObjectUtils.tryCast((Object)this.myButtons.get((Object)button2), AnActionButton.class));
    }

    @Nullable
    public AnAction getAnAction(@NotNull Buttons button2) {
        if (button2 == null) {
            CommonActionsPanel.$$$reportNull$$$0(4);
        }
        return this.myButtons.get((Object)button2);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        for (AnAction button2 : this.myActions) {
            ShortcutSet customShortCut;
            ShortcutSet shortcut;
            if (button2 instanceof AnActionButton) {
                AnActionButton anActionButton = (AnActionButton)button2;
                shortcut = anActionButton.getShortcut();
            } else {
                shortcut = button2.getShortcutSet();
            }
            if (shortcut == null) continue;
            if (button2 instanceof MyActionButton && this.myCustomShortcuts != null && (customShortCut = this.myCustomShortcuts.get((Object)((MyActionButton)button2).myButton)) != null) {
                shortcut = customShortCut;
            }
            button2.registerCustomShortcutSet(shortcut, this.myToolbar.getTargetComponent());
            if (!(button2 instanceof RemoveButton)) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button2);
        }
        super.addNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction(IdeBundle.messagePointer("action.Anonymous.text.delete.hook", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                removeButton.actionPerformed(e);
            }

            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            public void update(@NotNull AnActionEvent e) {
                JComponent contextComponent;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((contextComponent = removeButton.getContextComponent()) instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/CommonActionsPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/CommonActionsPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button2, boolean enabled) {
        AnAction b = this.myButtons.get((Object)button2);
        if (b instanceof AnActionButton) {
            AnActionButton anActionButton = (AnActionButton)b;
            anActionButton.setEnabled(enabled);
        }
    }

    public void setCustomShortcuts(@NotNull Buttons button2, ShortcutSet ... shortcutSets) {
        if (button2 == null) {
            CommonActionsPanel.$$$reportNull$$$0(5);
        }
        if (shortcutSets != null) {
            if (this.myCustomShortcuts == null) {
                this.myCustomShortcuts = new EnumMap(Buttons.class);
            }
            this.myCustomShortcuts.put(button2, new CompositeShortcutSet(shortcutSets));
        } else if (this.myCustomShortcuts != null) {
            this.myCustomShortcuts.remove((Object)button2);
            if (this.myCustomShortcuts.isEmpty()) {
                this.myCustomShortcuts = null;
            }
        }
    }

    @NotNull
    public ActionToolbarPosition getPosition() {
        ActionToolbarPosition actionToolbarPosition = this.myPosition;
        if (actionToolbarPosition == null) {
            CommonActionsPanel.$$$reportNull$$$0(6);
        }
        return actionToolbarPosition;
    }

    @Nullable
    public RelativePoint getPreferredPopupPoint(@NotNull AnAction action) {
        if (action == null) {
            CommonActionsPanel.$$$reportNull$$$0(7);
        }
        return CommonActionsPanel.computePreferredPopupPoint(this.getToolbar().getComponent(), action);
    }

    @ApiStatus.Internal
    public static RelativePoint getPreferredPopupPoint(@NotNull AnAction action, @Nullable Component contextComponent) {
        RelativePoint preferredPoint;
        ActionToolbar toolbar;
        Object o;
        if (action == null) {
            CommonActionsPanel.$$$reportNull$$$0(8);
        }
        Component c = contextComponent;
        if (contextComponent instanceof ActionToolbar) {
            o = (ActionToolbar)contextComponent;
            v0 = o;
        } else {
            v0 = toolbar = null;
        }
        while (toolbar == null && c != null && (c = c.getParent()) != null) {
            if (!(c instanceof JComponent)) continue;
            o = (JComponent)c;
            toolbar = (ActionToolbar)((JComponent)o).getClientProperty("ACTION_TOOLBAR");
        }
        if (toolbar != null && (preferredPoint = CommonActionsPanel.computePreferredPopupPoint(toolbar.getComponent(), action)) != null) {
            return preferredPoint;
        }
        return null;
    }

    @Nullable
    static RelativePoint computePreferredPopupPoint(@NotNull JComponent toolbar, @NotNull AnAction action) {
        if (toolbar == null) {
            CommonActionsPanel.$$$reportNull$$$0(9);
        }
        if (action == null) {
            CommonActionsPanel.$$$reportNull$$$0(10);
        }
        for (Component comp : toolbar.getComponents()) {
            AnAction componentAction;
            if (comp instanceof AnActionHolder) {
                AnActionHolder o = (AnActionHolder)((Object)comp);
                v0 = o.getAction();
            } else if (comp instanceof JComponent) {
                JComponent o = (JComponent)comp;
                v0 = (AnAction)ClientProperty.get((Component)o, (Key)CustomComponentAction.ACTION_KEY);
            } else {
                v0 = componentAction = null;
            }
            if (componentAction != action && (!(componentAction instanceof ActionWithDelegate) || ((ActionWithDelegate)componentAction).getDelegate() != action)) continue;
            return new RelativePoint((Component)comp.getParent(), new Point(comp.getX(), comp.getY() + comp.getHeight()));
        }
        return null;
    }

    @NotNull
    public static ShortcutSet getCommonShortcut(@NotNull Buttons button2) {
        if (button2 == null) {
            CommonActionsPanel.$$$reportNull$$$0(11);
        }
        ShortcutSet shortcutSet = switch (button2.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CommonShortcuts.getNewForDialogs();
            case 2 -> CustomShortcutSet.fromString((String[])new String[]{"ENTER"});
            case 1 -> CustomShortcutSet.fromString((String[])new String[]{ClientSystemInfo.isMac() ? "meta BACK_SPACE" : "alt DELETE"});
            case 3 -> CommonShortcuts.MOVE_UP;
            case 4 -> CommonShortcuts.MOVE_DOWN;
        };
        if (shortcutSet == null) {
            CommonActionsPanel.$$$reportNull$$$0(12);
        }
        return shortcutSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnActionButton";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCustomShortcuts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredPopupPoint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computePreferredPopupPoint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommonShortcut";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 12 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface ListenerFactory {
        @NotNull
        public Listener createListener(@NotNull CommonActionsPanel var1);
    }

    public static interface Listener {
        default public void doAdd() {
        }

        default public void doRemove() {
        }

        default public void doUp() {
        }

        default public void doDown() {
        }

        default public void doEdit() {
        }
    }

    public static enum Buttons {
        ADD(AllIcons.General.Add, (Supplier)UIBundle.messagePointer("button.text.add", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                if (listener2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new AddButton(listener2, name == null ? this.getText() : name, icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$1";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        REMOVE(AllIcons.General.Remove, (Supplier)UIBundle.messagePointer("button.text.remove", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                if (listener2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (icon == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new RemoveButton(listener2, name == null ? this.getText() : name, icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$2";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        EDIT(AllIcons.Actions.Edit, (Supplier)UIBundle.messagePointer("button.text.edit", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                if (listener2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (icon == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new EditButton(listener2, name == null ? this.getText() : name, icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$3";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UP(IconUtil.getMoveUpIcon(), (Supplier)UIBundle.messagePointer("button.text.up", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                if (listener2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (icon == null) {
                    4.$$$reportNull$$$0(1);
                }
                return new UpButton(listener2, name == null ? this.getText() : name, icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$4";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DOWN(IconUtil.getMoveDownIcon(), (Supplier)UIBundle.messagePointer("button.text.down", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                if (listener2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (icon == null) {
                    5.$$$reportNull$$$0(1);
                }
                return new DownButton(listener2, name == null ? this.getText() : name, icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/CommonActionsPanel$Buttons$5";
                objectArray[2] = "createButton";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final Icon myIcon;
        private final @NotNull Supplier<@NlsContexts.Button String> myText;

        private Buttons(Icon icon, Supplier<String> text) {
            if (icon == null) {
                Buttons.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Buttons.$$$reportNull$$$0(1);
            }
            this.myIcon = icon;
            this.myText = text;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                Buttons.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        abstract AnActionButton createButton(@NotNull Listener var1, @NlsContexts.Button String var2, @NotNull Icon var3);

        @NlsContexts.Button
        @NotNull
        public String getText() {
            String string = this.myText.get();
            if (string == null) {
                Buttons.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/CommonActionsPanel$Buttons";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/CommonActionsPanel$Buttons";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static abstract class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        protected final Listener myListener;

        MyActionButton(@NotNull Buttons button2, @NotNull Listener listener2, @NlsContexts.Button @NotNull String name, @NotNull Icon icon) {
            if (button2 == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            if (listener2 == null) {
                MyActionButton.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyActionButton.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MyActionButton.$$$reportNull$$$0(3);
            }
            super(name, name, icon);
            this.myButton = button2;
            this.myListener = listener2;
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public final void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionButton.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabled(this.isEnabled() && this.isContextComponentShowingAndEnabled() && this.isContextComponentStateAllowingAction() && this.isEventAllowingAction(e));
        }

        private boolean isContextComponentShowingAndEnabled() {
            JComponent component = this.getContextComponent();
            return component != null && component.isShowing() && component.isEnabled();
        }

        private boolean isContextComponentStateAllowingAction() {
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                return this.isEnabled(size, min, max);
            }
            return true;
        }

        protected boolean isEventAllowingAction(AnActionEvent e) {
            return true;
        }

        @NotNull
        public final ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyActionButton.$$$reportNull$$$0(5);
            }
            return actionUpdateThread;
        }

        protected abstract boolean isEnabled(int var1, int var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/CommonActionsPanel$MyActionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/CommonActionsPanel$MyActionButton";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateButton";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class RemoveButton
    extends MyActionButton {
        RemoveButton(Listener listener2, @NlsContexts.Button String name, Icon icon) {
            super(Buttons.REMOVE, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveButton.$$$reportNull$$$0(0);
            }
            this.myListener.doRemove();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$RemoveButton", "actionPerformed"));
        }
    }

    static final class DownButton
    extends MyActionButton {
        DownButton(Listener listener2, @NlsContexts.Button String name, Icon icon) {
            super(Buttons.DOWN, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && max < size - 1;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DownButton.$$$reportNull$$$0(0);
            }
            this.myListener.doDown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$DownButton", "actionPerformed"));
        }
    }

    static final class UpButton
    extends MyActionButton {
        UpButton(Listener listener2, @NlsContexts.Button String name, Icon icon) {
            super(Buttons.UP, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min >= 1;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpButton.$$$reportNull$$$0(0);
            }
            this.myListener.doUp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$UpButton", "actionPerformed"));
        }
    }

    static final class EditButton
    extends MyActionButton {
        EditButton(Listener listener2, @NlsContexts.Button String name, Icon icon) {
            super(Buttons.EDIT, listener2, name, icon);
        }

        @Override
        protected boolean isEventAllowingAction(AnActionEvent e) {
            JComponent c = this.getContextComponent();
            InputEvent inputEvent = e.getInputEvent();
            return !(inputEvent instanceof KeyEvent) || !(c instanceof JTable) || !((JTable)c).isEditing() || inputEvent.getComponent() instanceof ActionButtonComponent;
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min == max && min >= 0;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditButton.$$$reportNull$$$0(0);
            }
            this.myListener.doEdit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$EditButton", "actionPerformed"));
        }
    }

    static final class AddButton
    extends MyActionButton {
        AddButton(Listener listener2, @NlsContexts.Button String name, Icon icon) {
            super(Buttons.ADD, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddButton.$$$reportNull$$$0(0);
            }
            this.myListener.doAdd();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/CommonActionsPanel$AddButton", "actionPerformed"));
        }
    }
}

