/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.impl.BaselineData;
import com.intellij.ui.dsl.gridLayout.impl.ColumnsSizeCalculator;
import com.intellij.ui.dsl.gridLayout.impl.LayoutCellData;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\fJ\u000e\u0010@\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\fJ\u000e\u0010A\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\fJ\u000e\u0010B\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\fJ\u000e\u0010:\u001a\u0002092\u0006\u0010C\u001a\u00020DR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010(\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010)\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0014R\u001a\u0010+\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0018\"\u0004\b-\u0010\u001aR\u001a\u0010.\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0018\"\u0004\b0\u0010\u001aR\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160#X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010(\u001a\u0004\b6\u0010%\"\u0004\b7\u0010'R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006E"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/LayoutData;", "", "<init>", "()V", "respectMinimumSize", "", "getRespectMinimumSize", "()Z", "setRespectMinimumSize", "(Z)V", "visibleCellsData", "", "Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "getVisibleCellsData", "()Ljava/util/List;", "setVisibleCellsData", "(Ljava/util/List;)V", "columnsSizeCalculator", "Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "getColumnsSizeCalculator", "()Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "minimumWidth", "", "getMinimumWidth", "()I", "setMinimumWidth", "(I)V", "preferredWidth", "getPreferredWidth", "setPreferredWidth", "dimension", "Ljava/awt/Dimension;", "getDimension", "()Ljava/awt/Dimension;", "columnsCoord", "", "getColumnsCoord", "()[Ljava/lang/Integer;", "setColumnsCoord", "([Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "rowsSizeCalculator", "getRowsSizeCalculator", "minimumHeight", "getMinimumHeight", "setMinimumHeight", "preferredHeight", "getPreferredHeight", "setPreferredHeight", "baselineData", "Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "getBaselineData", "()Lcom/intellij/ui/dsl/gridLayout/impl/BaselineData;", "rowsCoord", "getRowsCoord", "setRowsCoord", "outsideGaps", "Lcom/intellij/ui/dsl/gridLayout/Gaps;", "getOutsideGaps", "()Lcom/intellij/ui/dsl/gridLayout/Gaps;", "setOutsideGaps", "(Lcom/intellij/ui/dsl/gridLayout/Gaps;)V", "getPaddedWidth", "layoutCellData", "getFullPaddedWidth", "getHeight", "getFullPaddedHeight", "parentInsets", "Ljava/awt/Insets;", "intellij.platform.ide"})
final class LayoutData {
    private boolean respectMinimumSize;
    @NotNull
    private List<LayoutCellData> visibleCellsData = CollectionsKt.emptyList();
    @NotNull
    private final ColumnsSizeCalculator columnsSizeCalculator = new ColumnsSizeCalculator();
    private int minimumWidth;
    private int preferredWidth;
    @NotNull
    private final Dimension dimension = new Dimension();
    @NotNull
    private Integer[] columnsCoord = new Integer[0];
    @NotNull
    private final ColumnsSizeCalculator rowsSizeCalculator = new ColumnsSizeCalculator();
    private int minimumHeight;
    private int preferredHeight;
    @NotNull
    private final BaselineData baselineData = new BaselineData();
    @NotNull
    private Integer[] rowsCoord = new Integer[0];
    @NotNull
    private Gaps outsideGaps = new Gaps(0, 0, 0, 0);

    public final boolean getRespectMinimumSize() {
        return this.respectMinimumSize;
    }

    public final void setRespectMinimumSize(boolean bl) {
        this.respectMinimumSize = bl;
    }

    @NotNull
    public final List<LayoutCellData> getVisibleCellsData() {
        return this.visibleCellsData;
    }

    public final void setVisibleCellsData(@NotNull List<LayoutCellData> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.visibleCellsData = list;
    }

    @NotNull
    public final ColumnsSizeCalculator getColumnsSizeCalculator() {
        return this.columnsSizeCalculator;
    }

    public final int getMinimumWidth() {
        return this.minimumWidth;
    }

    public final void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    @NotNull
    public final Dimension getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Integer[] getColumnsCoord() {
        return this.columnsCoord;
    }

    public final void setColumnsCoord(@NotNull Integer[] integerArray) {
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"<set-?>");
        this.columnsCoord = integerArray;
    }

    @NotNull
    public final ColumnsSizeCalculator getRowsSizeCalculator() {
        return this.rowsSizeCalculator;
    }

    public final int getMinimumHeight() {
        return this.minimumHeight;
    }

    public final void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }

    public final int getPreferredHeight() {
        return this.preferredHeight;
    }

    public final void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    @NotNull
    public final BaselineData getBaselineData() {
        return this.baselineData;
    }

    @NotNull
    public final Integer[] getRowsCoord() {
        return this.rowsCoord;
    }

    public final void setRowsCoord(@NotNull Integer[] integerArray) {
        Intrinsics.checkNotNullParameter((Object)integerArray, (String)"<set-?>");
        this.rowsCoord = integerArray;
    }

    @NotNull
    public final Gaps getOutsideGaps() {
        return this.outsideGaps;
    }

    public final void setOutsideGaps(@NotNull Gaps gaps) {
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"<set-?>");
        this.outsideGaps = gaps;
    }

    public final int getPaddedWidth(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        int fullPaddedWidth = this.getFullPaddedWidth(layoutCellData);
        return layoutCellData.getCell().getConstraints().getHorizontalAlign() == HorizontalAlign.FILL ? fullPaddedWidth : Math.min(fullPaddedWidth, layoutCellData.getPreferredSize().width - layoutCellData.getScaledVisualPaddings().getWidth());
    }

    public final int getFullPaddedWidth(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints = layoutCellData.getCell().getConstraints();
        return this.columnsCoord[constraints.getX() + constraints.getWidth()] - this.columnsCoord[constraints.getX()] - layoutCellData.getGapWidth();
    }

    public final int getHeight(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        Constraints constraints = layoutCellData.getCell().getConstraints();
        return this.rowsCoord[constraints.getY() + constraints.getHeight()] - this.rowsCoord[constraints.getY()];
    }

    public final int getFullPaddedHeight(@NotNull LayoutCellData layoutCellData) {
        Intrinsics.checkNotNullParameter((Object)layoutCellData, (String)"layoutCellData");
        return this.getHeight(layoutCellData) - layoutCellData.getGapHeight();
    }

    @NotNull
    public final Gaps getOutsideGaps(@NotNull Insets parentInsets) {
        Intrinsics.checkNotNullParameter((Object)parentInsets, (String)"parentInsets");
        return new Gaps(Math.max(this.outsideGaps.getTop(), parentInsets.top), Math.max(this.outsideGaps.getLeft(), parentInsets.left), Math.max(this.outsideGaps.getBottom(), parentInsets.bottom), Math.max(this.outsideGaps.getRight(), parentInsets.right));
    }
}

