/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u000fH$J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R<\u0010\u0006\u001a.\u0012*\u0012(\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b0\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lcom/intellij/util/messages/impl/BaseBusConnection;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "<init>", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "subscriptions", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "kotlin.jvm.PlatformType", "isDisposed", "", "()Z", "subscribe", "", "L", "topic", "Lcom/intellij/util/messages/Topic;", "handler", "(Lcom/intellij/util/messages/Topic;Ljava/lang/Object;)V", "collectHandlers", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "disconnect", "toString", "", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lcom/intellij/util/messages/impl/SimpleMessageBusConnectionImpl;", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nBaseBusConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,91:1\n37#2,2:92\n*S KotlinDebug\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n*L\n82#1:92,2\n*E\n"})
public abstract class BaseBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    @JvmField
    @Nullable
    public MessageBusImpl bus;
    @JvmField
    @NotNull
    protected final AtomicReference<Object[]> subscriptions;

    private BaseBusConnection(MessageBusImpl bus) {
        this.bus = bus;
        this.subscriptions = new AtomicReference<Object[]>(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public boolean isDisposed() {
        return this.bus == null;
    }

    public final <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        MessageBusImpl messageBusImpl = this.bus;
        if (messageBusImpl == null) {
            throw new AlreadyDisposedException("Message bus connection is closed: " + this);
        }
        MessageBusImpl liveBus = messageBusImpl;
        Object[] list = null;
        Object[] newList = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)this.subscriptions.get(), (String)"get(...)");
            if (list.length == 0) {
                Object[] objectArray = new Object[]{topic, handler};
                newList = objectArray;
                continue;
            }
            int size = list.length;
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(list, size + 2), (String)"copyOf(...)");
            newList[size] = topic;
            newList[size + 1] = handler;
        } while (!this.subscriptions.compareAndSet(list, newList));
        liveBus.notifyOnSubscription$intellij_platform_core(topic);
    }

    @Override
    public void collectHandlers(@NotNull Topic<?> topic, @NotNull List<? super Object> result) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Object[] list = this.subscriptions.get();
        int n = list.length;
        for (int i = 0; i < n; i += 2) {
            if (list[i] != topic) continue;
            Object object = list[i + 1];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            result.add(object);
        }
    }

    @Override
    public void disconnectIfNeeded(@NotNull Predicate<Class<?>> predicate) {
        Collection $this$toTypedArray$iv;
        Collection thisCollection$iv;
        Object[] list;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        do {
            list = this.subscriptions.get();
            List newList = null;
            for (int i = 0; i < list.length; i += 2) {
                if (predicate.test(list[i + 1].getClass())) {
                    if (newList != null) continue;
                    Intrinsics.checkNotNull((Object)list);
                    newList = CollectionsKt.toMutableList((Collection)ArraysKt.asList((Object[])list).subList(0, i));
                    continue;
                }
                if (newList == null) continue;
                Object object = list[i];
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                newList.add(object);
                Object object2 = list[i + 1];
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                newList.add(object2);
            }
            if (newList == null) {
                return;
            }
            if (newList.isEmpty()) {
                this.disconnect();
                return;
            }
            $this$toTypedArray$iv = newList;
            boolean $i$f$toTypedArray = false;
        } while (!this.subscriptions.compareAndSet(list, (thisCollection$iv = $this$toTypedArray$iv).toArray(new Object[0])));
    }

    protected abstract void disconnect();

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.subscriptions.get());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ BaseBusConnection(MessageBusImpl bus, DefaultConstructorMarker $constructor_marker) {
        this(bus);
    }
}

