/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.metrics.database;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.MetricTableColumn;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.tables.MetricTable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u00a8\u0006\u000b"}, d2={"getCreateStatement", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/database/tables/MetricTable;", "getInsertStatement", "getDeleteStatementForFile", "getIndexStatement", "getSumStatement", "sumColumn", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/database/MetricTableColumn;", "getSchemaForAllTables", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/database/tables/MetricTable$Companion;", "intellij.qodana"})
public final class Metrics_sql_statementsKt {
    @NotNull
    public static final String getCreateStatement(@NotNull MetricTable $this$getCreateStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$getCreateStatement, (String)"<this>");
        String columnNameTypes = CollectionsKt.joinToString$default((Iterable)$this$getCreateStatement.getColumns(), (CharSequence)",", null, null, (int)0, null, Metrics_sql_statementsKt::getCreateStatement$lambda$0, (int)30, null);
        return "CREATE TABLE " + $this$getCreateStatement.getTableName() + " (" + columnNameTypes + ");";
    }

    @NotNull
    public static final String getInsertStatement(@NotNull MetricTable $this$getInsertStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$getInsertStatement, (String)"<this>");
        String placeholderString = CollectionsKt.joinToString$default((Iterable)$this$getInsertStatement.getColumns(), (CharSequence)", ", null, null, (int)0, null, Metrics_sql_statementsKt::getInsertStatement$lambda$0, (int)30, null);
        return "INSERT OR REPLACE INTO " + $this$getInsertStatement.getTableName() + " VALUES(" + placeholderString + ");";
    }

    @NotNull
    public static final String getDeleteStatementForFile(@NotNull MetricTable $this$getDeleteStatementForFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeleteStatementForFile, (String)"<this>");
        return "DELETE FROM " + $this$getDeleteStatementForFile.getTableName() + " WHERE " + $this$getDeleteStatementForFile.getFilePathColumn().getColumnName() + " = ?;";
    }

    @Nullable
    public static final String getIndexStatement(@NotNull MetricTable $this$getIndexStatement) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getIndexStatement, (String)"<this>");
        MetricTableColumn metricTableColumn = $this$getIndexStatement.getIndexColumn();
        if (metricTableColumn != null) {
            MetricTableColumn index = metricTableColumn;
            boolean bl = false;
            string = "CREATE INDEX idx_" + $this$getIndexStatement.getTableName() + "_file_path ON " + $this$getIndexStatement.getTableName() + " (" + index.getColumnName() + ");";
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getSumStatement(@NotNull MetricTable $this$getSumStatement, @NotNull MetricTableColumn sumColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$getSumStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sumColumn, (String)"sumColumn");
        return "SELECT SUM(" + sumColumn.getColumnName() + ") FROM " + $this$getSumStatement.getTableName() + ";";
    }

    @NotNull
    public static final String getSchemaForAllTables(@NotNull MetricTable.Companion $this$getSchemaForAllTables) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForAllTables, (String)"<this>");
        List tables = $this$getSchemaForAllTables.getEP().getExtensionList();
        String createStatements = CollectionsKt.joinToString$default((Iterable)tables, (CharSequence)"", null, null, (int)0, null, Metrics_sql_statementsKt::getSchemaForAllTables$lambda$0, (int)30, null);
        String indexStatements = CollectionsKt.joinToString$default((Iterable)tables, (CharSequence)"", null, null, (int)0, null, Metrics_sql_statementsKt::getSchemaForAllTables$lambda$1, (int)30, null);
        return StringsKt.trimIndent((String)("\n    BEGIN TRANSACTION;\n    " + createStatements + "\n    " + indexStatements + "\n    COMMIT;\n    "));
    }

    private static final CharSequence getCreateStatement$lambda$0(MetricTableColumn c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return c.getColumnName() + " " + c.getColumnType().getTypeName();
    }

    private static final CharSequence getInsertStatement$lambda$0(MetricTableColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "?";
    }

    private static final CharSequence getSchemaForAllTables$lambda$0(MetricTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Metrics_sql_statementsKt.getCreateStatement(it);
    }

    private static final CharSequence getSchemaForAllTables$lambda$1(MetricTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Metrics_sql_statementsKt.getIndexStatement(it);
        return string != null ? (CharSequence)string : (CharSequence)"";
    }
}

