/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.openapi.application.ApplicationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Utils_time_loggerKt;
import org.jline.terminal.TerminalBuilder;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a$\u0010\b\u001a\u00020\u00052\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logoLines", "", "", "textLines", "printProductHeader", "", "warnDeprecated", "productName", "printLogoAndInfo", "qodanaInfo", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nLogo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logo.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/LogoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1#2:77\n1586#3:78\n1661#3,3:79\n*S KotlinDebug\n*F\n+ 1 Logo.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/LogoKt\n*L\n47#1:78\n47#1:79,3\n*E\n"})
public final class LogoKt {
    @NotNull
    private static final List<String> logoLines = StringsKt.lines((CharSequence)"                                        \n          _              _       \n         /\\ \\           /\\ \\     \n        /  \\ \\         /  \\ \\    \n       / /\\ \\ \\       / /\\ \\ \\   \n      / / /\\ \\ \\     / / /\\ \\ \\  \n     / / /  \\ \\_\\   / / /  \\ \\_\\ \n    / / / _ / / /  / / /   / / / \n   / / / /\\ \\/ /  / / /   / / /  \n  / / /__\\ \\ \\/  / / /___/ / /   \n / / /____\\ \\ \\ / / /____\\/ /    \n \\/________\\_\\/ \\/_________/     \n                                                   \n                                        ");
    @NotNull
    private static final List<String> textLines = StringsKt.lines((CharSequence)"\n   Documentation\n   https://jb.gg/qodana-docs\n   Contact us at\n   qodana-support@jetbrains.com\n   Or via our issue tracker\n   https://jb.gg/qodana-issue\n   Or share your feedback at our forum\n   https://jb.gg/qodana-forum\n\n");

    /*
     * WARNING - void declaration
     */
    public static final void printProductHeader() {
        void $this$mapTo$iv$iv;
        String productName = QodanaKt.getQodanaProductName();
        LogoKt.warnDeprecated(productName);
        Object[] objectArray = new String[]{"", "   " + productName + " " + ApplicationInfo.getInstance().getFullVersion()};
        List qodanaInfo = CollectionsKt.listOf((Object[])objectArray);
        qodanaInfo = CollectionsKt.plus((Collection)qodanaInfo, (Iterable)textLines);
        int defaultTerminalLength = 80;
        Integer n = TerminalBuilder.terminal().getWidth();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int terminalWidth = n2 != null ? n2 : defaultTerminalLength;
        String string = (String)CollectionsKt.lastOrNull(logoLines);
        int logoWidth = string != null ? Utils_time_loggerKt.lengthOnTerminal(string) : 0;
        int reasonablePlaceForInfo = 28;
        if (logoWidth + reasonablePlaceForInfo > terminalWidth) {
            Iterable iterable = qodanaInfo;
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            System.out.println((Object)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
        }
        Iterable $this$map$iv = qodanaInfo;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(StringsKt.chunked((CharSequence)((CharSequence)it2), (int)(terminalWidth - logoWidth - 1)));
        }
        qodanaInfo = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        LogoKt.printLogoAndInfo(logoLines, qodanaInfo);
    }

    private static final void warnDeprecated(String productName) {
        if (Intrinsics.areEqual((Object)productName, (Object)"Qodana Deprecated common")) {
            String string = "The Docker image 'jetbrains/qodana' support will be stopped on November, 19th. \nNew Qodana images can check your Java, Kotlin, Python, PHP, and JavaScript code!\nPlease upgrade to the latest images for technologies used in your project";
            System.out.println((Object)string);
        }
    }

    private static final void printLogoAndInfo(List<String> logoLines, List<String> qodanaInfo) {
        List alignedLogoLines = logoLines;
        List alignedQodanaInfo = qodanaInfo;
        int dif = Math.abs(logoLines.size() - qodanaInfo.size());
        if (logoLines.size() < qodanaInfo.size()) {
            Collection<String> collection;
            int n;
            String emptyLine = StringsKt.repeat((CharSequence)" ", (int)((String)CollectionsKt.first(logoLines)).length());
            int n2 = dif / 2;
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n = n3++;
                collection = arrayList;
                boolean bl = false;
                collection.add(emptyLine);
            }
            n2 = dif / 2 + dif % 2;
            collection = CollectionsKt.plus((Collection)arrayList, (Iterable)logoLines);
            arrayList = new ArrayList(n2);
            n3 = 0;
            while (n3 < n2) {
                int it = n = n3++;
                ArrayList<String> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(emptyLine);
            }
            alignedLogoLines = CollectionsKt.plus(collection, (Iterable)arrayList);
        } else if (qodanaInfo.size() < logoLines.size()) {
            Collection<String> collection;
            int it;
            int n;
            String emptyLine = "";
            int n5 = dif / 2;
            ArrayList<String> arrayList = new ArrayList<String>(n5);
            int n6 = 0;
            while (n6 < n5) {
                it = n = n6++;
                collection = arrayList;
                boolean bl = false;
                collection.add(emptyLine);
            }
            n5 = dif / 2 + dif % 2;
            collection = CollectionsKt.plus((Collection)arrayList, (Iterable)qodanaInfo);
            arrayList = new ArrayList(n5);
            n6 = 0;
            while (n6 < n5) {
                it = n = n6++;
                ArrayList<String> arrayList3 = arrayList;
                boolean bl = false;
                arrayList3.add(emptyLine);
            }
            alignedQodanaInfo = CollectionsKt.plus(collection, (Iterable)arrayList);
        }
        Iterable iterable = CollectionsKt.zip((Iterable)alignedLogoLines, (Iterable)alignedQodanaInfo);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, LogoKt::printLogoAndInfo$lambda$4, (int)30, null));
    }

    private static final CharSequence printLogoAndInfo$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "" + it.getFirst() + it.getSecond();
    }
}

