/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.qodana.sarif.model.ArtifactContent;
import com.jetbrains.qodana.sarif.model.Region;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.EnvKt;
import org.jetbrains.qodana.staticAnalysis.sarif.Border;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u001f\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"CONTEXT_MAX_LINES_MARGIN", "", "MAX_CONTEXT_CHARS_LENGTH", "getContextRegion", "Lcom/jetbrains/qodana/sarif/model/Region;", "problem", "Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;", "text", "", "linesMargin", "fileLanguage", "Lcom/intellij/lang/Language;", "getProblemOffset", "(Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/sarif/CommonDescriptor;)Ljava/lang/Integer;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\ncontextRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 contextRegion.kt\norg/jetbrains/qodana/staticAnalysis/sarif/ContextRegionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class ContextRegionKt {
    public static final int CONTEXT_MAX_LINES_MARGIN = 2;
    public static final int MAX_CONTEXT_CHARS_LENGTH = 1800;

    @Nullable
    public static final Region getContextRegion(@NotNull CommonDescriptor problem, @NotNull String text2, int linesMargin, @Nullable Language fileLanguage) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (EnvKt.qodanaEnv().getQODANA_DISABLE_COLLECT_CONTEXT().getValue() != null) {
            return null;
        }
        Integer n = ContextRegionKt.getProblemOffset(text2, problem);
        if (n == null) {
            return null;
        }
        int offset = n;
        Integer n2 = problem.getLine();
        if (n2 == null) {
            return null;
        }
        int it = ((Number)n2).intValue();
        boolean bl = false;
        int line = it - 1;
        if (problem.getLength() == null) {
            return null;
        }
        Border leftBorder = new Border(offset, line, text2, new IntRange(line - linesMargin, line + linesMargin));
        LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)text2, (int)(offset + problem.getLength()));
        if (lineColumn == null) {
            return null;
        }
        int rightBorderLine = lineColumn.line;
        Border rightBorder = new Border(offset + problem.getLength(), rightBorderLine, text2, new IntRange(rightBorderLine - linesMargin, rightBorderLine + linesMargin));
        boolean leftMoved = true;
        boolean rightMoved = true;
        while (rightBorder.getCurrentOffset() - leftBorder.getCurrentOffset() < 1800 && (leftMoved || rightMoved)) {
            leftMoved = leftBorder.moveLeft();
            rightMoved = rightBorder.moveRight();
        }
        int leftOffset = Integer.max(0, leftBorder.getCurrentOffset());
        int rightOffset = Math.min(rightBorder.getCurrentOffset(), text2.length());
        LineColumn lineColumn2 = StringUtil.offsetToLineColumn((CharSequence)text2, (int)leftOffset);
        Region region = new Region().withStartColumn(Integer.valueOf(lineColumn2.column + 1)).withStartLine(Integer.valueOf(lineColumn2.line + 1)).withCharLength(Integer.valueOf(rightOffset - leftOffset)).withCharOffset(Integer.valueOf(leftOffset)).withSnippet(new ArtifactContent().withText(((Object)text2.subSequence(leftOffset, rightOffset)).toString()));
        if (fileLanguage != null) {
            region.withSourceLanguage(fileLanguage.getID());
        }
        return region;
    }

    public static /* synthetic */ Region getContextRegion$default(CommonDescriptor commonDescriptor, String string, int n, Language language, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            language = null;
        }
        return ContextRegionKt.getContextRegion(commonDescriptor, string, n, language);
    }

    @Nullable
    public static final Integer getProblemOffset(@NotNull String text2, @NotNull CommonDescriptor problem) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Integer n = problem.getLine();
        if (n == null) {
            return null;
        }
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        int line = it - 1;
        Integer n2 = problem.getColumn();
        if (n2 == null) {
            return null;
        }
        int column = n2;
        boolean bl3 = bl = line >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return StringUtil.lineColToOffset((CharSequence)text2, (int)line, (int)column);
    }
}

