/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.yaml;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.yaml.QodanaYamlUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/qodana/yaml/QodanaShowInspectionIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "getText", "", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "startInWriteAction", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "invoke", "", "findInspectionName", "offset", "file", "iterateOverElements", "Lkotlin/sequences/Sequence;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaShowInspectionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaShowInspectionIntention.kt\norg/jetbrains/qodana/yaml/QodanaShowInspectionIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class QodanaShowInspectionIntention
implements IntentionAction,
Iconable {
    @NotNull
    public String getText() {
        String string = QodanaBundle.message("qodana.yaml.intention.show.inspection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return (PsiElement)currentFile;
    }

    @NotNull
    public String getFamilyName() {
        String string = QodanaBundle.message("qodana.yaml.intention.family", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = QodanaIcons.Icons.Qodana;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Qodana");
        return icon;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null || !QodanaYamlUtilsKt.isQodanaYaml(psiFile)) {
            return false;
        }
        if (editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        return this.findInspectionName(offset, psiFile) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null || editor == null) {
            return;
        }
        String inspectionName = this.findInspectionName(editor.getCaretModel().getOffset(), psiFile);
        if (inspectionName != null) {
            Project project2 = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            QodanaYamlUtilsKt.showInspection(project2, inspectionName);
        }
    }

    private final String findInspectionName(int offset, PsiFile file2) {
        InspectionToolWrapper inspectionToolWrapper;
        block1: {
            for (PsiElement p0 : this.iterateOverElements(offset, file2)) {
                boolean bl = false;
                InspectionToolWrapper inspectionToolWrapper2 = QodanaYamlUtilsKt.getInspectionFromElement$default(p0, false, 2, null);
                if (inspectionToolWrapper2 == null) continue;
                inspectionToolWrapper = inspectionToolWrapper2;
                break block1;
            }
            inspectionToolWrapper = null;
        }
        return inspectionToolWrapper != null ? inspectionToolWrapper.getShortName() : null;
    }

    private final Sequence<PsiElement> iterateOverElements(int offset, PsiFile file2) {
        PsiElement leaf1 = file2.findElementAt(offset);
        PsiElement leaf2 = file2.findElementAt(offset - 1);
        PsiElement commonParent = leaf1 != null && leaf2 != null ? PsiTreeUtil.findCommonParent((PsiElement)leaf1, (PsiElement)leaf2) : null;
        Sequence elementsToCheck = SequencesKt.emptySequence();
        if (leaf1 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)leaf1), arg_0 -> QodanaShowInspectionIntention.iterateOverElements$lambda$0(commonParent, arg_0)));
        }
        if (leaf2 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)leaf2), arg_0 -> QodanaShowInspectionIntention.iterateOverElements$lambda$1(commonParent, arg_0)));
        }
        if (commonParent != null && !(commonParent instanceof PsiFile)) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)commonParent));
        }
        return elementsToCheck;
    }

    private static final boolean iterateOverElements$lambda$0(PsiElement $commonParent, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$commonParent);
    }

    private static final boolean iterateOverElements$lambda$1(PsiElement $commonParent, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$commonParent);
    }
}

