/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.jcef.JBCefScrollbarsHelper;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.PreviewStyleScheme;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles;", "", "<init>", "()V", "defaultFontSize", "", "getDefaultFontSize", "()I", "createStylesheet", "", "webRgba", "Ljava/awt/Color;", "alpha", "", "Variables", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nPreviewLAFThemeStyles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewLAFThemeStyles.kt\norg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,83:1\n42#2,3:84\n*S KotlinDebug\n*F\n+ 1 PreviewLAFThemeStyles.kt\norg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles\n*L\n16#1:84,3\n*E\n"})
public final class PreviewLAFThemeStyles {
    @NotNull
    public static final PreviewLAFThemeStyles INSTANCE = new PreviewLAFThemeStyles();

    private PreviewLAFThemeStyles() {
    }

    public final int getDefaultFontSize() {
        boolean $i$f$service = false;
        Class<MarkdownPreviewSettings> serviceClass$iv = MarkdownPreviewSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((MarkdownPreviewSettings.State)((MarkdownPreviewSettings)((Object)object)).getState()).getFontSize();
    }

    @NotNull
    public final String createStylesheet() {
        PreviewStyleScheme scheme = PreviewStyleScheme.Companion.fromCurrentTheme();
        String separatorColor = PreviewLAFThemeStyles.webRgba$default(this, scheme.getSeparatorColor(), 0.0, 1, null);
        String infoForeground = PreviewLAFThemeStyles.webRgba$default(this, scheme.getInfoForegroundColor(), 0.0, 1, null);
        String backgroundColor = PreviewLAFThemeStyles.webRgba$default(this, scheme.getBackgroundColor(), 0.0, 1, null);
        return StringsKt.trimIndent((String)("\n    :root {\n      --default-font-size: " + scheme.getFontSize() + "px;\n    }\n\n    body {\n        background-color: " + backgroundColor + ";\n        font-size: var(--default-font-size) !important;\n    }\n    \n    body, p, blockquote, ul, ol, dl, table, pre, code, tr  {\n        color: " + PreviewLAFThemeStyles.webRgba$default(this, scheme.getForegroundColor(), 0.0, 1, null) + ";\n    }\n    \n    a {\n        color: " + PreviewLAFThemeStyles.webRgba$default(this, scheme.getLinkActiveForegroundColor(), 0.0, 1, null) + ";\n    }\n    \n    table td, table th {\n      border: 1px solid " + separatorColor + ";\n    }\n    \n    hr {\n      background-color: " + separatorColor + ";\n    }\n    \n    kbd, tr {\n      border: 1px solid " + separatorColor + ";\n    }\n    \n    h6 {\n        color: " + infoForeground + ";\n    }\n    \n    blockquote {\n      border-left: 2px solid " + this.webRgba(scheme.getLinkActiveForegroundColor(), 0.4) + ";\n    }\n    \n    blockquote, code, pre {\n      background-color: " + this.webRgba(scheme.getFenceBackgroundColor(), (double)scheme.getFenceBackgroundColor().getAlpha() / 255.0) + ";\n    }\n    \n    " + JBCefScrollbarsHelper.buildScrollbarsStyle() + "\n    \n    "));
    }

    private final String webRgba(Color $this$webRgba, double alpha) {
        return "rgba(" + $this$webRgba.getRed() + ", " + $this$webRgba.getGreen() + ", " + $this$webRgba.getBlue() + ", " + alpha + ")";
    }

    static /* synthetic */ String webRgba$default(PreviewLAFThemeStyles previewLAFThemeStyles, Color color, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = color.getAlpha();
        }
        return previewLAFThemeStyles.webRgba(color, d);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles$Variables;", "", "<init>", "()V", "FontSize", "", "intellij.markdown"})
    public static final class Variables {
        @NotNull
        public static final Variables INSTANCE = new Variables();
        @NotNull
        public static final String FontSize = "--default-font-size";

        private Variables() {
        }
    }
}

