/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.xml;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.parser.MarkdownFlavourUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0006H\u0014R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/xml/DefaultMarkdownFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "relevantLanguages", "", "Lcom/intellij/lang/Language;", "kotlin.jvm.PlatformType", "createFile", "Lcom/intellij/psi/PsiFile;", "language", "getBaseLanguage", "getLanguages", "getTemplateDataLanguage", "cloneInner", "fileCopy", "intellij.markdown.xml"})
public final class DefaultMarkdownFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Set<Language> relevantLanguages;

    public DefaultMarkdownFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(manager, file, eventSystemEnabled);
        Object[] objectArray = new Language[]{MarkdownLanguage.INSTANCE, HTMLLanguage.INSTANCE};
        this.relevantLanguages = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) {
            return (PsiFile)MarkdownFlavourUtil.createMarkdownFile((FileViewProvider)this);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        PsiFile psiFile = parserDefinition2.createFile((FileViewProvider)this);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFile(...)");
        PsiFile file = psiFile;
        if (language == this.getTemplateDataLanguage() && file instanceof PsiFileImpl) {
            ((PsiFileImpl)file).setContentElementType((IElementType)MarkdownElementTypes.MARKDOWN_TEMPLATE_DATA);
        }
        return file;
    }

    @NotNull
    public Language getBaseLanguage() {
        MarkdownLanguage markdownLanguage = MarkdownLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownLanguage), (String)"INSTANCE");
        return markdownLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return this.relevantLanguages;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        return (Language)HTMLLanguage.INSTANCE;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new DefaultMarkdownFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }
}

