/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors.gutter;

import com.intellij.diff.util.DiffLineNumberConverter;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorGutterListener;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.ex.lineNumber.LineNumberConvertersKt;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.CustomLineNumbers;
import com.jetbrains.rd.ide.model.DoProviderActionData;
import com.jetbrains.rd.ide.model.DocumentPositionInfo;
import com.jetbrains.rd.ide.model.EditorGutterTextAnnotationsModel;
import com.jetbrains.rd.ide.model.LineAnnotationPersistenceModel;
import com.jetbrains.rd.ide.model.LineAnnotationStateModel;
import com.jetbrains.rd.ide.model.LineNumbersStateModel;
import com.jetbrains.rd.ide.model.LinesAnnotationsModel;
import com.jetbrains.rd.ide.model.LinesNumbersModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdGutterModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.document.BackendDocumentHostKt;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0002,-B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001aH\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u001c\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010+\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager;", "Lcom/intellij/openapi/editor/impl/EditorGutterListener;", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "gutterEx", "Lcom/intellij/openapi/editor/ex/EditorGutterComponentEx;", "protocolGutter", "Lcom/jetbrains/rd/ide/model/EditorGutterTextAnnotationsModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/ex/EditorGutterComponentEx;Lcom/jetbrains/rd/ide/model/EditorGutterTextAnnotationsModel;Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;)V", "_providersIdCounter", "", "getUniqueProviderId", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "shifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "providers2ProvidersIds", "", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "providersIds2Providers", "performAfterInitiationActivities", "", "startListeningDocument", "startListeningProtocol", "textAnnotationAdded", "provider", "textAnnotationRemoved", "lineNumberConvertersChanged", "isConverterMatchesDefault", "", "converter", "Lcom/intellij/openapi/editor/LineNumberConverter;", "convertLineNumberToString", "", "lineNumberConverter", "lineNumber", "Companion", "MyEditorHostListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendEditorGutterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorGutterManager.kt\ncom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n1915#2,2:208\n1915#2,2:211\n1#3:210\n13#4:213\n*S KotlinDebug\n*F\n+ 1 BackendEditorGutterManager.kt\ncom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager\n*L\n82#1:208,2\n100#1:211,2\n33#1:213\n*E\n"})
public final class BackendEditorGutterManager
implements EditorGutterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime editorLifetime;
    @NotNull
    private final Editor editor;
    @NotNull
    private final EditorGutterComponentEx gutterEx;
    @NotNull
    private final EditorGutterTextAnnotationsModel protocolGutter;
    @NotNull
    private final DocumentSynchronizer documentSynchronizer;
    private int _providersIdCounter;
    @NotNull
    private final IDocumentRangeShifter shifter;
    @NotNull
    private final Map<TextAnnotationGutterProvider, Integer> providers2ProvidersIds;
    @NotNull
    private final Map<Integer, TextAnnotationGutterProvider> providersIds2Providers;
    @NotNull
    private static final Logger LOG;

    public BackendEditorGutterManager(@NotNull Lifetime editorLifetime, @NotNull Editor editor, @NotNull EditorGutterComponentEx gutterEx, @NotNull EditorGutterTextAnnotationsModel protocolGutter, @NotNull DocumentSynchronizer documentSynchronizer) {
        Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)gutterEx, (String)"gutterEx");
        Intrinsics.checkNotNullParameter((Object)protocolGutter, (String)"protocolGutter");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        this.editorLifetime = editorLifetime;
        this.editor = editor;
        this.gutterEx = gutterEx;
        this.protocolGutter = protocolGutter;
        this.documentSynchronizer = documentSynchronizer;
        this.shifter = this.documentSynchronizer.createRangeShifter();
        this.providers2ProvidersIds = new LinkedHashMap();
        this.providersIds2Providers = new LinkedHashMap();
    }

    private final int getUniqueProviderId() {
        int n = this._providersIdCounter;
        this._providersIdCounter = n + 1;
        return n;
    }

    private final Document getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    private final void performAfterInitiationActivities() {
        this.startListeningDocument();
        this.startListeningProtocol();
        this.lineNumberConvertersChanged();
    }

    private final void startListeningDocument() {
        if (this.editor.isDisposed()) {
            return;
        }
        List list = this.gutterEx.getTextAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTextAnnotations(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextAnnotationGutterProvider it = (TextAnnotationGutterProvider)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.textAnnotationAdded(it);
        }
        this.gutterEx.addEditorGutterListener((EditorGutterListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.editorLifetime, null, (int)1, null));
    }

    private final void startListeningProtocol() {
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.protocolGutter.getGetLinesAnnotations()), null, null, arg_0 -> BackendEditorGutterManager.startListeningProtocol$lambda$0(this, arg_0), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.protocolGutter.getGetCustomLineNumbers()), null, null, arg_0 -> BackendEditorGutterManager.startListeningProtocol$lambda$1(this, arg_0), (int)3, null);
        this.protocolGutter.getDoProviderAction().advise(this.editorLifetime, arg_0 -> BackendEditorGutterManager.startListeningProtocol$lambda$2(this, arg_0));
    }

    public void textAnnotationAdded(@NotNull TextAnnotationGutterProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        int providerId = this.getUniqueProviderId();
        this.providers2ProvidersIds.put(provider, providerId);
        this.providersIds2Providers.put(providerId, provider);
        this.protocolGutter.getOnProviderAdded().fire((Object)providerId);
    }

    public void textAnnotationRemoved(@NotNull TextAnnotationGutterProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Integer n = this.providers2ProvidersIds.get(provider);
        if (n == null) {
            BackendEditorGutterManager $this$textAnnotationRemoved_u24lambda_u240 = this;
            boolean bl = false;
            LOG.error((Throwable)new IllegalStateException("provider=" + provider));
            return;
        }
        int providerId = n;
        this.providers2ProvidersIds.remove(provider);
        this.providersIds2Providers.remove(providerId);
        this.protocolGutter.getOnProviderRemoved().fire((Object)providerId);
    }

    public void lineNumberConvertersChanged() {
        CustomLineNumbers customLineNumbers;
        if (this.gutterEx.getAdditionalLineNumberConverter() != null) {
            customLineNumbers = CustomLineNumbers.BOTH;
        } else {
            LineNumberConverter lineNumberConverter = this.gutterEx.getPrimaryLineNumberConverter();
            Intrinsics.checkNotNullExpressionValue((Object)lineNumberConverter, (String)"getPrimaryLineNumberConverter(...)");
            customLineNumbers = !this.isConverterMatchesDefault(lineNumberConverter) ? CustomLineNumbers.PRIMARY : CustomLineNumbers.NONE;
        }
        CustomLineNumbers mode = customLineNumbers;
        this.protocolGutter.getCustomLineNumbers().set((Object)mode);
    }

    private final boolean isConverterMatchesDefault(LineNumberConverter converter) {
        if (converter instanceof DiffLineNumberConverter) {
            return !((DiffLineNumberConverter)converter).hasCustomLineNumbers();
        }
        EditorSettings.LineNumerationType lineNumerationType = this.editor.getSettings().getLineNumerationType();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumerationType, (String)"getLineNumerationType(...)");
        return Intrinsics.areEqual((Object)converter, (Object)LineNumberConvertersKt.getStandardLineNumberConverter((EditorSettings.LineNumerationType)lineNumerationType));
    }

    private final String convertLineNumberToString(LineNumberConverter lineNumberConverter, int lineNumber) {
        if (lineNumberConverter == null) {
            return null;
        }
        if (lineNumberConverter instanceof DiffLineNumberConverter) {
            return ((DiffLineNumberConverter)lineNumberConverter).convertLineNumberToStringImpl(lineNumber, false);
        }
        return lineNumberConverter.convertLineNumberToString(this.editor, lineNumber);
    }

    private static final LinesAnnotationsModel startListeningProtocol$lambda$0(BackendEditorGutterManager this$0, DocumentPositionInfo annotationsPositionInfo) {
        Intrinsics.checkNotNullParameter((Object)annotationsPositionInfo, (String)"annotationsPositionInfo");
        AbstractDocumentVersion oldVersion = annotationsPositionInfo.getDocVersion();
        RdTextRange oldRange = annotationsPositionInfo.getRange();
        int it = this$0.shifter.shiftOnePoint(oldVersion, oldRange.getStartOffset(), false);
        boolean bl = false;
        int startOffset = it < 0 ? 0 : (it > this$0.getDocument().getTextLength() ? this$0.getDocument().getTextLength() : it);
        int it2 = this$0.shifter.shiftOnePoint(oldVersion, oldRange.getEndOffset(), true);
        boolean bl2 = false;
        int endOffset = it2 < 0 ? startOffset : (it2 > this$0.getDocument().getTextLength() ? this$0.getDocument().getTextLength() : it2);
        int startLineNumber = this$0.getDocument().getLineNumber(startOffset);
        int endLineNumber = this$0.getDocument().getLineNumber(endOffset);
        List lineAnnotationsStatesModels = new ArrayList();
        List list = this$0.editor.getGutter().getTextAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTextAnnotations(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            TextAnnotationGutterProvider provider = (TextAnnotationGutterProvider)element$iv;
            boolean bl3 = false;
            Integer n = this$0.providers2ProvidersIds.get(provider);
            if (n == null) continue;
            int providerId = ((Number)n).intValue();
            boolean bl4 = false;
            int lineNumber = startLineNumber;
            if (lineNumber > endLineNumber) continue;
            while (true) {
                ColorKey colorKey = provider.getColor(lineNumber, this$0.editor);
                Color color = provider.getBgColor(lineNumber, this$0.editor);
                lineAnnotationsStatesModels.add(new LineAnnotationStateModel(providerId, new LineAnnotationPersistenceModel(provider.getLineText(lineNumber, this$0.editor), (ColorKeyModel)(colorKey != null ? ColorHostKt.toModel((ColorKey)colorKey) : null), (AbstractColor)(color != null ? ColorHostKt.toModel((Color)color) : null), provider.getToolTip(lineNumber, this$0.editor)), this$0.getDocument().getLineStartOffset(lineNumber), this$0.getDocument().getLineEndOffset(lineNumber)));
                if (lineNumber == endLineNumber) continue block0;
                ++lineNumber;
            }
        }
        return new LinesAnnotationsModel(this$0.documentSynchronizer.getVersion(), lineAnnotationsStatesModels);
    }

    private static final LinesNumbersModel startListeningProtocol$lambda$1(BackendEditorGutterManager this$0, DocumentPositionInfo linesPositionInfo) {
        Intrinsics.checkNotNullParameter((Object)linesPositionInfo, (String)"linesPositionInfo");
        AbstractDocumentVersion oldVersion = linesPositionInfo.getDocVersion();
        RdTextRange oldRange = linesPositionInfo.getRange();
        int it = this$0.shifter.shiftOnePoint(oldVersion, oldRange.getStartOffset(), false);
        boolean bl = false;
        int startOffset = it < 0 ? 0 : (it > this$0.getDocument().getTextLength() ? this$0.getDocument().getTextLength() : it);
        int it2 = this$0.shifter.shiftOnePoint(oldVersion, oldRange.getEndOffset(), true);
        boolean bl2 = false;
        int endOffset = it2 < 0 ? startOffset : (it2 > this$0.getDocument().getTextLength() ? this$0.getDocument().getTextLength() : it2);
        int startLineNumber = this$0.getDocument().getLineNumber(startOffset);
        int endLineNumber = this$0.getDocument().getLineNumber(endOffset);
        LineNumberConverter lineNumberConverter = this$0.gutterEx.getPrimaryLineNumberConverter();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConverter, (String)"getPrimaryLineNumberConverter(...)");
        LineNumberConverter primaryConverter = lineNumberConverter;
        LineNumberConverter additionalConverter = this$0.gutterEx.getAdditionalLineNumberConverter();
        List lineNumbersStatesModels = new ArrayList();
        int lineNumber = startLineNumber;
        if (lineNumber <= endLineNumber) {
            while (true) {
                lineNumbersStatesModels.add(new LineNumbersStateModel(this$0.convertLineNumberToString(primaryConverter, lineNumber), this$0.convertLineNumberToString(additionalConverter, lineNumber), this$0.getDocument().getLineStartOffset(lineNumber), this$0.getDocument().getLineEndOffset(lineNumber)));
                if (lineNumber == endLineNumber) break;
                ++lineNumber;
            }
        }
        String primaryMaxNumber = primaryConverter.getMaxLineNumberString(this$0.editor);
        LineNumberConverter lineNumberConverter2 = additionalConverter;
        String additionalMaxNumber = lineNumberConverter2 != null ? lineNumberConverter2.getMaxLineNumberString(this$0.editor) : null;
        return new LinesNumbersModel(primaryMaxNumber, additionalMaxNumber, this$0.documentSynchronizer.getVersion(), lineNumbersStatesModels);
    }

    private static final Unit startListeningProtocol$lambda$2(BackendEditorGutterManager this$0, DoProviderActionData doProviderActionData) {
        RdTextRange oldRange;
        Intrinsics.checkNotNullParameter((Object)doProviderActionData, (String)"<destruct>");
        int providerId = doProviderActionData.component1();
        DocumentPositionInfo annotationsPositionInfo = doProviderActionData.component2();
        TextAnnotationGutterProvider textAnnotationGutterProvider = this$0.providersIds2Providers.get(providerId);
        if (textAnnotationGutterProvider == null) {
            return Unit.INSTANCE;
        }
        TextAnnotationGutterProvider provider = textAnnotationGutterProvider;
        EditorGutterAction editorGutterAction = this$0.gutterEx.getAction(provider);
        if (editorGutterAction == null) {
            return Unit.INSTANCE;
        }
        EditorGutterAction action = editorGutterAction;
        AbstractDocumentVersion oldVersion = annotationsPositionInfo.getDocVersion();
        int startOffset = this$0.shifter.shiftOnePoint(oldVersion, (oldRange = annotationsPositionInfo.getRange()).getStartOffset(), false);
        if (startOffset < 0 || startOffset > this$0.getDocument().getTextLength()) {
            return Unit.INSTANCE;
        }
        int lineNumber = this$0.editor.getDocument().getLineNumber(startOffset);
        UIEventLogger.EditorAnnotationClicked.log(this$0.editor.getProject(), provider.getClass());
        action.doAction(lineNumber);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendEditorGutterManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager$MyEditorHostListener;", "Lcom/jetbrains/rdserver/editors/BackendEditorHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendEditorGutterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorGutterManager.kt\ncom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager$MyEditorHostListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,207:1\n67#2,4:208\n*S KotlinDebug\n*F\n+ 1 BackendEditorGutterManager.kt\ncom/jetbrains/rdserver/editors/gutter/BackendEditorGutterManager$MyEditorHostListener\n*L\n43#1:208,4\n*E\n"})
    public static final class MyEditorHostListener
    implements BackendEditorHostListener {
        @Override
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("editorBound() called: editor=" + editor);
            }
            EditorGutter editorGutter = editor.getGutter();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutter, (String)"getGutter(...)");
            EditorGutter gutter = editorGutter;
            if (!(gutter instanceof EditorGutterComponentEx)) {
                LOG.error((Throwable)new IllegalStateException("It is not possible to register BackendEditorGutterManager because `editor.gutter` is not an instance of EditorGutterComponentEx class: editor=" + editor + ", gutter=" + gutter));
                return;
            }
            RdDocumentId documentId = textControlId.getDocumentId();
            DocumentSynchronizer documentSynchronizer = BackendDocumentHostKt.toSynchronizerOrNull(documentId, appSession);
            if (documentSynchronizer == null) {
                return;
            }
            DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
            RdGutterModel_GeneratedKt.getRdGutterModel((TextControlModel)editorModel).getTextAnnotationsModel().advise(lifetime, arg_0 -> MyEditorHostListener.editorBound$lambda$1(lifetime, editor, gutter, documentSynchronizer2, arg_0));
        }

        private static final Unit editorBound$lambda$1(Lifetime $lifetime, Editor $editor, EditorGutter $gutter, DocumentSynchronizer $documentSynchronizer, EditorGutterTextAnnotationsModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            BackendEditorGutterManager manager = new BackendEditorGutterManager($lifetime, $editor, (EditorGutterComponentEx)$gutter, it, $documentSynchronizer);
            manager.performAfterInitiationActivities();
            return Unit.INSTANCE;
        }
    }
}

