/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.findUsages;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesManager;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewPopup;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.popups.RdPopupWindowContextBase;
import com.jetbrains.rd.ide.model.FindUsagesModel;
import com.jetbrains.rd.ide.model.FindUsagesModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdEditorScreenPositionPopupWindowContext;
import com.jetbrains.rd.ide.model.RdShowUsagesSession;
import com.jetbrains.rd.ide.model.RdUsageList;
import com.jetbrains.rd.ide.model.RdUsageTargetList;
import com.jetbrains.rd.ide.model.RdUsagesSession;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rdserver.actions.ClientPoint;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.findUsages.RdUsageView;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J:\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/findUsages/BackendShowUsagesManager;", "Lcom/intellij/find/actions/ShowUsagesManager;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lkotlinx/coroutines/CoroutineScope;)V", "currentClientFindUsagesModel", "Lcom/jetbrains/rd/ide/model/FindUsagesModel;", "getCurrentClientFindUsagesModel", "()Lcom/jetbrains/rd/ide/model/FindUsagesModel;", "sessionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "showElementUsagesWithResult", "Ljava/util/concurrent/Future;", "", "Lcom/intellij/usages/Usage;", "parameters", "Lcom/intellij/find/actions/ShowUsagesParameters;", "actionHandler", "Lcom/intellij/find/actions/ShowUsagesActionHandler;", "usageView", "Lcom/intellij/usages/impl/UsageViewImpl;", "createUsageViewModel", "Lcom/jetbrains/rdserver/findUsages/RdUsageView;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "presentation", "Lcom/intellij/usages/UsageViewPresentation;", "intellij.platform.backend.split"})
public final class BackendShowUsagesManager
extends ShowUsagesManager {
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicInteger sessionId;

    public BackendShowUsagesManager(@NotNull ClientProjectSession session, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.session = session;
        this.coroutineScope = coroutineScope;
        this.sessionId = new AtomicInteger(100000);
        this.getCurrentClientFindUsagesModel().getResetMaximalScopeContext().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.session)), arg_0 -> BackendShowUsagesManager._init_$lambda$0(this, arg_0));
    }

    private final FindUsagesModel getCurrentClientFindUsagesModel() {
        return FindUsagesModel_GeneratedKt.getFindUsagesHost((Solution)RemoteSessionKt.getProtocolModel(this.session));
    }

    @NotNull
    public Future<Collection<Usage>> showElementUsagesWithResult(@NotNull ShowUsagesParameters parameters, @NotNull ShowUsagesActionHandler actionHandler, @NotNull UsageViewImpl usageView) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"actionHandler");
        Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
        Editor editor = parameters.getEditor();
        TextControlId textControlId = editor != null ? BackendEditorHost.Companion.textControlIdForSession(editor, this.session.getAppSession()) : null;
        Lifetime lifetime = RLifetimeKt.intersect((Lifetime)((Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)usageView))), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.session)));
        UsageViewPresentation usageViewPresentation = usageView.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)usageViewPresentation, (String)"getPresentation(...)");
        RdUsageView protocolAdapter = this.createUsageViewModel(lifetime, this.session, textControlId, parameters, actionHandler, usageViewPresentation);
        Disposer.register((Disposable)((Disposable)protocolAdapter), (Disposable)((Disposable)usageView));
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        UsageSearcher usageSearcher = actionHandler.createUsageSearcher();
        Intrinsics.checkNotNullExpressionValue((Object)usageSearcher, (String)"createUsageSearcher(...)");
        UsageSearcher usageSearcher2 = usageSearcher;
        CompletableFuture result = new CompletableFuture();
        List usages = new ArrayList();
        SearchScope searchScope = actionHandler.getSelectedScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getSelectedScope(...)");
        SearchScope searchScope2 = searchScope;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.everythingScope((Project)this.session.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"everythingScope(...)");
        GlobalSearchScope everythingScope = globalSearchScope;
        FindUsagesManager.startProcessUsages((ProgressIndicator)((ProgressIndicator)indicator), (Project)this.session.getProject(), (UsageSearcher)usageSearcher2, arg_0 -> BackendShowUsagesManager.showElementUsagesWithResult$lambda$1(arg_0 -> BackendShowUsagesManager.showElementUsagesWithResult$lambda$0(searchScope2, everythingScope, usages, protocolAdapter, arg_0), arg_0), () -> BackendShowUsagesManager.showElementUsagesWithResult$lambda$2(protocolAdapter, result, usages));
        return result;
    }

    private final RdUsageView createUsageViewModel(Lifetime lifetime, ClientProjectSession session, TextControlId textControlId, ShowUsagesParameters parameters, ShowUsagesActionHandler actionHandler, UsageViewPresentation presentation) {
        RdEditorScreenPositionPopupWindowContext rdEditorScreenPositionPopupWindowContext;
        ClientPoint originalPoint;
        RdUsageTargetList targetList = new RdUsageTargetList(presentation.getTargetsNodeText(), CollectionsKt.emptyList());
        RdUsageList usageList = new RdUsageList("", Unit.INSTANCE);
        String string = actionHandler.getPresentation().getSearchTargetString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchTargetString(...)");
        String title = string;
        Point point = parameters.getPopupPosition().getOriginalPoint();
        ClientPoint clientPoint = originalPoint = point instanceof ClientPoint ? (ClientPoint)point : null;
        if (originalPoint != null) {
            Editor editor = parameters.getEditor();
            rdEditorScreenPositionPopupWindowContext = new RdEditorScreenPositionPopupWindowContext(editor != null ? BackendEditorHost.Companion.textControlIdForSession(editor, session.getAppSession()) : null, originalPoint.x, originalPoint.y);
        } else {
            rdEditorScreenPositionPopupWindowContext = null;
        }
        RdEditorScreenPositionPopupWindowContext context = rdEditorScreenPositionPopupWindowContext;
        String string2 = actionHandler.getSelectedScope().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        String scopeName = string2;
        boolean navigateToSingleUsageImmediately = actionHandler.navigateToSingleUsageImmediately();
        RdShowUsagesSession usageSession = new RdShowUsagesSession(textControlId, (RdPopupWindowContextBase)context, scopeName, parameters.getMaxUsages(), title, usageList, targetList, navigateToSingleUsageImmediately);
        int sessionId = this.sessionId.incrementAndGet();
        ((Map)this.getCurrentClientFindUsagesModel().getSessions()).put(sessionId, usageSession);
        usageSession.getRunFindUsages().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$0(actionHandler, arg_0));
        usageSession.getRunFindUsagesSettings().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$1(actionHandler, arg_0));
        usageSession.getShowMoreUsages().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$2(actionHandler, parameters, this, session, arg_0));
        usageSession.getChangeScope().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$3(session, actionHandler, this, parameters, arg_0));
        usageSession.getMaximalScopeProposed().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$4(parameters, actionHandler, arg_0));
        RdUsageView rdUsageView = new RdUsageView(session, new UsageTarget[0], (RdUsagesSession)usageSession, presentation);
        this.getCurrentClientFindUsagesModel().getSessions().advise(lifetime, arg_0 -> BackendShowUsagesManager.createUsageViewModel$lambda$5(sessionId, rdUsageView, arg_0));
        return rdUsageView;
    }

    private static final Unit _init_$lambda$0(BackendShowUsagesManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowUsagesAction.resetMaximalScopeSearch((Project)this$0.session.getProject());
        return Unit.INSTANCE;
    }

    private static final void showElementUsagesWithResult$lambda$2$0(RdUsageView $protocolAdapter, CompletableFuture $result, List $usages) {
        $protocolAdapter.searchFinished();
        $result.complete($usages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean showElementUsagesWithResult$lambda$0(SearchScope $searchScope, GlobalSearchScope $everythingScope, List $usages, RdUsageView $protocolAdapter, Usage usage) {
        if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)$searchScope, (SearchScope)((SearchScope)$everythingScope))) {
            return true;
        }
        List list = $usages;
        synchronized (list) {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)usage);
            boolean bl2 = $usages.add(usage);
        }
        $protocolAdapter.appendUsage(usage);
        return true;
    }

    private static final boolean showElementUsagesWithResult$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void showElementUsagesWithResult$lambda$2(RdUsageView $protocolAdapter, CompletableFuture $result, List $usages) {
        ApplicationKt.getApplication().invokeLater(() -> BackendShowUsagesManager.showElementUsagesWithResult$lambda$2$0($protocolAdapter, $result, $usages));
    }

    private static final Unit createUsageViewModel$lambda$0(ShowUsagesActionHandler $actionHandler, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $actionHandler.findUsages();
        return Unit.INSTANCE;
    }

    private static final Unit createUsageViewModel$lambda$1(ShowUsagesActionHandler $actionHandler, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $actionHandler.showDialog();
        return Unit.INSTANCE;
    }

    private static final Unit createUsageViewModel$lambda$2(ShowUsagesActionHandler $actionHandler, ShowUsagesParameters $parameters, BackendShowUsagesManager this$0, ClientProjectSession $session, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowUsagesParameters moreUsagesParameters = $actionHandler.moreUsages($parameters);
        if (moreUsagesParameters != null) {
            this$0.showElementUsagesWithResult(moreUsagesParameters, $actionHandler, (UsageViewImpl)new UsageViewPopup($session.getProject(), CoroutineScopeKt.childScope$default((CoroutineScope)this$0.coroutineScope, (String)"UsageViewPopup", null, (boolean)false, (int)6, null)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createUsageViewModel$lambda$3(ClientProjectSession $session, ShowUsagesActionHandler $actionHandler, BackendShowUsagesManager this$0, ShowUsagesParameters $parameters, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findGlobalScopeByName((Project)$session.getProject(), (String)it);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"findGlobalScopeByName(...)");
        GlobalSearchScope scope = globalSearchScope;
        ShowUsagesActionHandler handler = $actionHandler.withScope((SearchScope)scope);
        if (handler != null) {
            this$0.showElementUsagesWithResult($parameters, handler, (UsageViewImpl)new UsageViewPopup($session.getProject(), CoroutineScopeKt.childScope$default((CoroutineScope)this$0.coroutineScope, (String)"UsageViewPopup", null, (boolean)false, (int)6, null)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createUsageViewModel$lambda$4(ShowUsagesParameters $parameters, ShowUsagesActionHandler $actionHandler, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowUsagesAction.requestMaximalScopeSearch((ShowUsagesParameters)$parameters, (ShowUsagesActionHandler)$actionHandler);
        return Unit.INSTANCE;
    }

    private static final Unit createUsageViewModel$lambda$5(int $sessionId, RdUsageView $rdUsageView, IViewableMap.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((Number)it.getKey()).intValue() == $sessionId && it.getNewValueOpt() == null) {
            Disposer.dispose((Disposable)((Disposable)$rdUsageView));
        }
        return Unit.INSTANCE;
    }
}

