/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.internal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.model.WriteLockHolderToIndex;
import com.jetbrains.rd.ide.model.WriteLockInfo;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.internal.BackendWriteLocksMonitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/internal/BackendWriteLocksMonitor;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "intellij.platform.backend.split"})
public final class BackendWriteLocksMonitor
extends LifetimedService {
    @NotNull
    private final ClientProjectSession session;

    public BackendWriteLocksMonitor(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        StartupManager.getInstance((Project)this.session.getProject()).runWhenProjectIsInitialized(() -> BackendWriteLocksMonitor._init_$lambda$0(this));
    }

    private static final void _init_$lambda$0(BackendWriteLocksMonitor this$0) {
        if (RLifetimeKt.isNotAlive((Lifetime)this$0.getServiceLifetime())) {
            return;
        }
        ApplicationKt.getApplication().addApplicationListener(new ApplicationListener(this$0){
            private final MergingUpdateQueue sendDataQueue;
            private final Map<ClientId, WriteLockHolderToIndex> uniqueHoldersMap;
            private final List<Integer> holdersSequence;
            final /* synthetic */ BackendWriteLocksMonitor this$0;
            {
                this.this$0 = $receiver;
                this.sendDataQueue = new MergingUpdateQueue("sendDataQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, null, null, false, 112, null);
                this.uniqueHoldersMap = new LinkedHashMap<K, V>();
                this.holdersSequence = new ArrayList<E>();
            }

            /*
             * WARNING - void declaration
             */
            public void writeActionStarted(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                try {
                    Object object;
                    void $this$getOrPut$iv;
                    ClientId currentHolder = ClientId.Companion.getCurrent();
                    if (Intrinsics.areEqual((Object)currentHolder, (Object)BackendWriteLocksMonitor.access$getSession$p(this.this$0).getClientId())) {
                        return;
                    }
                    String currentHolderName = BackendWriteLocksMonitor.access$getSession$p(this.this$0).getName();
                    Map<ClientId, WriteLockHolderToIndex> map2 = this.uniqueHoldersMap;
                    ClientId key$iv = currentHolder;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        WriteLockHolderToIndex answer$iv = new WriteLockHolderToIndex(currentHolderName, this.uniqueHoldersMap.size());
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    int index = ((WriteLockHolderToIndex)object).getIndex();
                    if (this.holdersSequence.isEmpty() || ((Number)CollectionsKt.last(this.holdersSequence)).intValue() != index) {
                        this.holdersSequence.add(index);
                    }
                    this.sendDataQueue.queue(new Update(this.this$0, this){
                        final /* synthetic */ BackendWriteLocksMonitor this$0;
                        final /* synthetic */ 1.1 this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super((Object)"update", false, 0, 6, null);
                        }

                        public void run() {
                            if (RLifetimeKt.isNotAlive((Lifetime)BackendWriteLocksMonitor.access$getServiceLifetime(this.this$0))) {
                                return;
                            }
                            RemoteSessionKt.getProtocolModel(BackendWriteLocksMonitor.access$getSession$p(this.this$0)).getWriteLockAcquired().fire((Object)new WriteLockInfo(CollectionsKt.toList((Iterable)1.1.access$getUniqueHoldersMap$p(this.this$1).values()), 1.1.access$getHoldersSequence$p(this.this$1)));
                            1.1.access$getUniqueHoldersMap$p(this.this$1).clear();
                            1.1.access$getHoldersSequence$p(this.this$1).clear();
                        }
                    });
                }
                catch (Exception e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(BackendWriteLocksMonitor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn((Throwable)e);
                }
            }

            public static final /* synthetic */ Map access$getUniqueHoldersMap$p(1.1 $this) {
                return $this.uniqueHoldersMap;
            }

            public static final /* synthetic */ List access$getHoldersSequence$p(1.1 $this) {
                return $this.holdersSequence;
            }
        }, (Disposable)this$0);
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(BackendWriteLocksMonitor $this) {
        return $this.session;
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(BackendWriteLocksMonitor $this) {
        return $this.getServiceLifetime();
    }
}

