/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.adapter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.jetbrains.rd.ide.model.LuxLayoutSource;
import com.jetbrains.rd.ide.model.LxAbstractComponentInfo;
import com.jetbrains.rd.ide.model.LxPanel;
import com.jetbrains.rd.ide.model.LxPanelInfo;
import com.jetbrains.rd.ide.model.LxSize;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.awt.LuxContentPaneWrapper;
import com.jetbrains.rdserver.lux.util.RenderingContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0014J\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter;", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "panelModel", "Lcom/jetbrains/rd/ide/model/LxPanel;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/LxPanel;Ljava/awt/Window;)V", "setMinimumSize", "", "size", "Ljava/awt/Dimension;", "setMaximumSize", "setPreferredSize", "sendSizeToClientIfNeeded", "initialSize", "receiveSize", "width", "", "height", "getContent", "Lcom/jetbrains/rdserver/lux/awt/LuxContentPaneWrapper;", "runWithKeyEventCatching", "", "action", "Lkotlin/Function0;", "preConfigure", "context", "Lcom/jetbrains/rdserver/lux/util/RenderingContext;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxPanelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxPanelAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n67#2,4:120\n74#2,4:124\n67#2,4:128\n74#2,4:132\n67#2,4:136\n74#2,4:140\n67#2,4:144\n67#2,4:149\n74#2,4:153\n1#3:148\n*S KotlinDebug\n*F\n+ 1 LuxPanelAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter\n*L\n58#1:120,4\n59#1:124,4\n65#1:128,4\n66#1:132,4\n72#1:136,4\n73#1:140,4\n114#1:144,4\n86#1:149,4\n87#1:153,4\n*E\n"})
public final class LuxPanelAdapter
extends LuxComponentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LuxPanelAdapter(Lifetime lifetime, LxPanel panelModel, Window window) {
        super(lifetime, panelModel, window);
    }

    public final void setMinimumSize(@NotNull Dimension size) {
        block1: {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.getModel().getMinimumSize().set((Object)UtilKt.toLx((Dimension)size));
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Set minimumSize. Old value: " + this.getModel().getMinimumSize().getValueOrNull() + ". New value: " + UtilKt.toLx((Dimension)size) + ". Node: " + this.getModel().getLocation());
            }
            Logger $this$traceThrowable$iv = this.getParanoidLogger();
            boolean $i$f$traceThrowable = false;
            if (!$this$traceThrowable$iv.isTraceEnabled()) break block1;
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
    }

    public final void setMaximumSize(@NotNull Dimension size) {
        block1: {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.getModel().getMaximumSize().set((Object)UtilKt.toLx((Dimension)size));
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Set maximumSize. Old value: " + this.getModel().getMaximumSize().getValueOrNull() + ". New value: " + UtilKt.toLx((Dimension)size) + ". Node: " + this.getModel().getLocation());
            }
            Logger $this$traceThrowable$iv = this.getParanoidLogger();
            boolean $i$f$traceThrowable = false;
            if (!$this$traceThrowable$iv.isTraceEnabled()) break block1;
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
    }

    public final void setPreferredSize(@NotNull Dimension size) {
        block1: {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.getModel().getPreferredSize().set((Object)UtilKt.toLx((Dimension)size));
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Set preferredSize. Old value: " + this.getModel().getPreferredSize().getValueOrNull() + ". New value: " + UtilKt.toLx((Dimension)size) + ". Node: " + this.getModel().getLocation());
            }
            Logger $this$traceThrowable$iv = this.getParanoidLogger();
            boolean $i$f$traceThrowable = false;
            if (!$this$traceThrowable$iv.isTraceEnabled()) break block1;
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
    }

    @Override
    public void sendSizeToClientIfNeeded(@Nullable Dimension initialSize) {
        SwingUtilities.invokeLater(() -> LuxPanelAdapter.sendSizeToClientIfNeeded$lambda$0(this, initialSize));
    }

    @Override
    protected void receiveSize(int width, int height) {
        SwingUtilities.invokeLater(() -> LuxPanelAdapter.receiveSize$lambda$0(this, width, height));
    }

    private final LuxContentPaneWrapper getContent() {
        Window window = this.getWindow();
        Intrinsics.checkNotNull((Object)window, (String)"null cannot be cast to non-null type javax.swing.RootPaneContainer");
        Container contentPane = ((RootPaneContainer)((Object)window)).getContentPane();
        LuxContentPaneWrapper luxContentPaneWrapper = contentPane instanceof LuxContentPaneWrapper ? (LuxContentPaneWrapper)contentPane : null;
        if (luxContentPaneWrapper == null) {
            LuxPanelAdapter $this$getContent_u24lambda_u240 = this;
            boolean bl = false;
            $this$getContent_u24lambda_u240.getLogger().error("Expected LuxContentPaneWrapper, got " + contentPane);
            return null;
        }
        return luxContentPaneWrapper;
    }

    @Override
    protected boolean runWithKeyEventCatching(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        LuxContentPaneWrapper luxContentPaneWrapper = this.getContent();
        return luxContentPaneWrapper != null ? luxContentPaneWrapper.runWithKeyEventCatching(action) : super.runWithKeyEventCatching(action);
    }

    public final void preConfigure(@NotNull RenderingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Pre-configuring component with " + context);
        }
        super.receiveSize(context.getWidth(), context.getHeight());
        this.setGraphicsConfiguration(context.getGraphicsConfiguration());
        this.getWindow().setVisible(true);
    }

    private static final void sendSizeToClientIfNeeded$lambda$0(LuxPanelAdapter this$0, Dimension $initialSize) {
        Logger logger;
        boolean resized;
        boolean bl;
        Dimension size;
        LuxContentPaneWrapper luxContentPaneWrapper = this$0.getContent();
        if (luxContentPaneWrapper == null) {
            return;
        }
        LuxContentPaneWrapper wrapper = luxContentPaneWrapper;
        LxSize modelSize = (LxSize)this$0.getModel().getSize().getValueOrNull();
        Dimension dimension = $initialSize;
        if (dimension == null) {
            dimension = size = wrapper.getPreferredSize();
        }
        if (size.width <= 0 && size.height <= 0) {
            return;
        }
        LxSize lxSize = modelSize;
        if (lxSize != null) {
            LxSize it = lxSize;
            boolean bl2 = false;
            boolean bl3 = it.getWidth() != size.width || it.getHeight() != size.height;
            bl = !bl3;
        } else {
            bl = false;
        }
        boolean bl4 = resized = !bl;
        if (!resized) {
            return;
        }
        Logger $this$trace$iv = this$0.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl5 = false;
            Object object = this$0.getModel().getPreferredSize().getValueOrNull();
            Intrinsics.checkNotNull((Object)size);
            logger.trace("Set preferredSize. Old value: " + object + ". New value: " + UtilKt.toLx((Dimension)size) + ". Node: " + this$0.getModel().getLocation());
        }
        Logger $this$traceThrowable$iv = this$0.getParanoidLogger();
        boolean $i$f$traceThrowable = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            logger = $this$traceThrowable$iv;
            boolean bl6 = false;
            logger.trace(new Throwable());
        }
        IOptProperty iOptProperty = this$0.getModel().getPreferredSize();
        Intrinsics.checkNotNull((Object)size);
        iOptProperty.set((Object)UtilKt.toLx((Dimension)size));
    }

    private static final void receiveSize$lambda$0(LuxPanelAdapter this$0, int $width, int $height) {
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)this$0.getLifetime()))) {
            return;
        }
        super.receiveSize($width, $height);
        LuxContentPaneWrapper luxContentPaneWrapper = this$0.getContent();
        if (luxContentPaneWrapper == null) {
            return;
        }
        LuxContentPaneWrapper wrapper = luxContentPaneWrapper;
        wrapper.setSize(new Dimension($width, $height));
    }

    public /* synthetic */ LuxPanelAdapter(Lifetime lifetime, LxPanel panelModel, Window window, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, panelModel, window);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "panel", "Ljava/awt/Component;", "window", "Ljava/awt/Window;", "realParent", "Ljava/awt/Container;", "layoutSource", "Lcom/jetbrains/rd/ide/model/LuxLayoutSource;", "focusableOnFrontend", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nLuxPanelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxPanelAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n23#2:120\n82#2,3:121\n67#2,4:124\n74#2,4:128\n*S KotlinDebug\n*F\n+ 1 LuxPanelAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter$Companion\n*L\n43#1:120\n43#1:121,3\n49#1:124,4\n50#1:128,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LuxPanelAdapter create(@NotNull Lifetime lifetime, @NotNull Component panel, @NotNull Window window, @Nullable Container realParent, @NotNull LuxLayoutSource layoutSource, boolean focusableOnFrontend) {
            LuxPanelAdapter luxPanelAdapter;
            block3: {
                Object $this$runAndLogException_u24lambda_u240$iv;
                void $this$runAndLogException$iv;
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                Intrinsics.checkNotNullParameter((Object)layoutSource, (String)"layoutSource");
                List<String> list = com.jetbrains.rdserver.lux.util.UtilKt.collectHierarchy(realParent);
                String string = com.jetbrains.rdserver.lux.util.UtilKt.getCreationStack(panel instanceof JComponent ? (JComponent)panel : null);
                String string2 = panel.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
                LxPanelInfo info2 = new LxPanelInfo(list, string, string2);
                LxPanel model2 = new LxPanel(layoutSource, focusableOnFrontend, (LxAbstractComponentInfo)info2);
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = logger;
                boolean $i$f$runAndLogException = false;
                void var11_12 = $this$runAndLogException$iv;
                try {
                    $this$runAndLogException_u24lambda_u240$iv = var11_12;
                    boolean bl = false;
                    boolean bl2 = false;
                    IOptProperty iOptProperty = model2.getPreferredSize();
                    Dimension dimension = panel.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    iOptProperty.set((Object)UtilKt.toLx((Dimension)dimension));
                    IOptProperty iOptProperty2 = model2.getMinimumSize();
                    Dimension dimension2 = panel.getMinimumSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getMinimumSize(...)");
                    iOptProperty2.set((Object)UtilKt.toLx((Dimension)dimension2));
                    IOptProperty iOptProperty3 = model2.getMaximumSize();
                    Dimension dimension3 = panel.getMaximumSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getMaximumSize(...)");
                    iOptProperty3.set((Object)UtilKt.toLx((Dimension)dimension3));
                    $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv);
                LuxPanelAdapter $this$create_u24lambda_u241 = luxPanelAdapter = new LuxPanelAdapter(lifetime, model2, window, null);
                boolean bl = false;
                Logger $this$trace$iv = $this$create_u24lambda_u241.getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl3 = false;
                    Dimension dimension = panel.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    LxSize lxSize = UtilKt.toLx((Dimension)dimension);
                    Dimension dimension4 = panel.getMinimumSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension4, (String)"getMinimumSize(...)");
                    LxSize lxSize2 = UtilKt.toLx((Dimension)dimension4);
                    Dimension dimension5 = panel.getMaximumSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension5, (String)"getMaximumSize(...)");
                    logger2.trace("Initial values. preferredSize: " + lxSize + ", minimumSize: " + lxSize2 + ", maximumSize: " + UtilKt.toLx((Dimension)dimension5) + ", ");
                }
                Logger $this$traceThrowable$iv = $this$create_u24lambda_u241.getParanoidLogger();
                boolean $i$f$traceThrowable = false;
                if (!$this$traceThrowable$iv.isTraceEnabled()) break block3;
                Logger logger3 = $this$traceThrowable$iv;
                boolean bl4 = false;
                logger3.trace(new Throwable());
            }
            return luxPanelAdapter;
        }

        public static /* synthetic */ LuxPanelAdapter create$default(Companion companion, Lifetime lifetime, Component component, Window window, Container container, LuxLayoutSource luxLayoutSource, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                luxLayoutSource = LuxLayoutSource.Frontend;
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            return companion.create(lifetime, component, window, container, luxLayoutSource, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

