/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\tH\u0014J\u0014\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/lux/awt/LuxContentPaneWrapper;", "Ljavax/swing/JPanel;", "mainComponent", "Ljava/awt/Component;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Ljava/awt/Component;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "keyEventPropagationDetected", "", "remove", "", "index", "", "processKeyBinding", "ks", "Ljavax/swing/KeyStroke;", "e", "Ljava/awt/event/KeyEvent;", "condition", "pressed", "runWithKeyEventCatching", "action", "Lkotlin/Function0;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxHostPanelWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxHostPanelWindow.kt\ncom/jetbrains/rdserver/lux/awt/LuxContentPaneWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 LuxHostPanelWindow.kt\ncom/jetbrains/rdserver/lux/awt/LuxContentPaneWrapper\n*L\n68#1:100\n*E\n"})
public final class LuxContentPaneWrapper
extends JPanel {
    @NotNull
    private final Lifetime lifetime;
    private boolean keyEventPropagationDetected;

    public LuxContentPaneWrapper(@NotNull Component mainComponent, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.setLayout(new BorderLayout());
        this.add(mainComponent);
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        if (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LuxContentPaneWrapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)new Exception("Component is removed from Lux container, original Lux binding stops working for it"));
        }
    }

    @Override
    protected boolean processKeyBinding(@NotNull KeyStroke ks, @NotNull KeyEvent e, int condition, boolean pressed) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.keyEventPropagationDetected = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runWithKeyEventCatching(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.keyEventPropagationDetected = false;
        try {
            action.invoke();
            boolean bl = this.keyEventPropagationDetected;
            return bl;
        }
        finally {
            this.keyEventPropagationDetected = false;
        }
    }
}

