/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.peer;

import com.jetbrains.rd.ide.model.LxRobotEventType;
import com.jetbrains.rdserver.lux.services.RobotHostService;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.peer.RobotPeer;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdserver/lux/awt/peer/LuxRobotPeer;", "Ljava/awt/peer/RobotPeer;", "<init>", "()V", "robotService", "Lcom/jetbrains/rdserver/lux/services/RobotHostService;", "getRobotService", "()Lcom/jetbrains/rdserver/lux/services/RobotHostService;", "mousePress", "", "buttons", "", "mouseMove", "x", "y", "mouseRelease", "mouseWheel", "amount", "keyPress", "keyCode", "keyRelease", "keycode", "getRGBPixel", "getRGBPixels", "", "bounds", "Ljava/awt/Rectangle;", "useAbsoluteCoordinates", "", "intellij.platform.backend.split"})
public final class LuxRobotPeer
implements RobotPeer {
    private final RobotHostService getRobotService() {
        RobotHostService robotHostService = RobotHostService.Companion.getControllerInstance();
        if (robotHostService == null) {
            throw new IllegalStateException("No controller session found".toString());
        }
        return robotHostService;
    }

    @Override
    public void mousePress(int buttons) {
        this.getRobotService().sendEvent(LxRobotEventType.PressMouse, buttons, null, 0, 0);
    }

    @Override
    public void mouseMove(int x, int y) {
        this.getRobotService().sendEvent(LxRobotEventType.MoveMouse, 0, new Point(x, y), 0, 0);
    }

    @Override
    public void mouseRelease(int buttons) {
        this.getRobotService().sendEvent(LxRobotEventType.ReleaseMouse, buttons, null, 0, 0);
    }

    @Override
    public void mouseWheel(int amount) {
        this.getRobotService().sendEvent(LxRobotEventType.RotateWheel, 0, null, amount, 0);
    }

    @Override
    public void keyPress(int keyCode) {
        throw new UnsupportedOperationException("Should not be called on remdev host");
    }

    @Override
    public void keyRelease(int keycode) {
        throw new UnsupportedOperationException("Should not be called on remdev host");
    }

    @Override
    public int getRGBPixel(int x, int y) {
        throw new UnsupportedOperationException("Should not be called on remdev host");
    }

    @Override
    @Nullable
    public int[] getRGBPixels(@Nullable Rectangle bounds) {
        throw new UnsupportedOperationException("Should not be called on remdev host");
    }

    @Override
    public boolean useAbsoluteCoordinates() {
        return true;
    }
}

