/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.requests;

import com.intellij.ide.rpc.DocumentPatchVersion;
import com.intellij.ide.rpc.DocumentPatchVersionAccessor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/requests/BackendDocumentVersionAccessor;", "Lcom/intellij/ide/rpc/DocumentPatchVersionAccessor;", "<init>", "()V", "getDocumentVersion", "Lcom/intellij/ide/rpc/DocumentPatchVersion;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.backend.split"})
public final class BackendDocumentVersionAccessor
implements DocumentPatchVersionAccessor {
    @Nullable
    public DocumentPatchVersion getDocumentVersion(@NotNull Document document, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BackendDocumentHost backendDocumentHost = BackendDocumentHost.Companion.getInstanceIfExists(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        if (backendDocumentHost == null) {
            return null;
        }
        BackendDocumentHost documentHost = backendDocumentHost;
        DocumentSynchronizer documentSynchronizer = documentHost.tryGetSynchronizer(document);
        if (documentSynchronizer == null || (documentSynchronizer = documentSynchronizer.getVersion()) == null) {
            return null;
        }
        DocumentSynchronizer version = documentSynchronizer;
        if (!(version instanceof RdDocumentVersion)) {
            return null;
        }
        return new DocumentPatchVersion(((RdDocumentVersion)version).getValue(), ((RdDocumentVersion)version).getHash());
    }
}

