/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.screenForwarding;

import com.intellij.execution.CantRunException;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.GlobalPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.util.NetUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingTargetEnvironment;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingUtilKt;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH$\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/screenForwarding/ScreenForwardingTargetEnvironmentRequestBase;", "Lcom/intellij/execution/target/local/LocalTargetEnvironmentRequest;", "<init>", "()V", "prepareEnvironment", "Lcom/intellij/execution/target/local/LocalTargetEnvironment;", "progressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "createServerProcesses", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "freeDisplay", "", "availablePort", "screenForwardingLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nScreenForwardingTargetEnvironmentRequestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenForwardingTargetEnvironmentRequestBase.kt\ncom/jetbrains/rdserver/screenForwarding/ScreenForwardingTargetEnvironmentRequestBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,91:1\n67#2,4:92\n67#2,4:96\n67#2,4:100\n13#2:105\n13#3:104\n*S KotlinDebug\n*F\n+ 1 ScreenForwardingTargetEnvironmentRequestBase.kt\ncom/jetbrains/rdserver/screenForwarding/ScreenForwardingTargetEnvironmentRequestBase\n*L\n33#1:92,4\n39#1:96,4\n65#1:100,4\n28#1:105\n28#1:104\n*E\n"})
public abstract class ScreenForwardingTargetEnvironmentRequestBase
extends LocalTargetEnvironmentRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public LocalTargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        progressIndicator.addText(SplitBackendBundle.INSTANCE.message("screen.forwarding.looking.for.free.xorg.display", new Object[0]), (Key)ProcessOutputType.SYSTEM);
        Logger $this$trace$iv = ScreenForwardingTargetEnvironmentRequestBase.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Finding free display...");
        }
        int freeDisplay = ScreenForwardingUtilKt.findFreeDisplay();
        if (freeDisplay < 0) {
            progressIndicator.stopWithErrorMessage(SplitBackendBundle.INSTANCE.message("screen.forwarding.failed.to.find.free.xorg.display", new Object[0]));
            throw new CantRunException(SplitBackendBundle.INSTANCE.message("screen.forwarding.failed.to.find.free.xorg.display", new Object[0]));
        }
        Logger $this$trace$iv2 = ScreenForwardingTargetEnvironmentRequestBase.logger;
        int $i$f$trace2 = 0;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("Looking for free port...");
        }
        try {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress(...)");
            $i$f$trace2 = NetUtil.findFirstAvailablePort$default((NetUtil)NetUtil.INSTANCE, (InetAddress)inetAddress, (int)15000, (int)0, (int)4, null);
        }
        catch (Throwable t) {
            throw new CantRunException(t.getLocalizedMessage(), t);
        }
        int availablePort = $i$f$trace2;
        LifetimeDefinition forwardingServerProcessesLifetime = new LifetimeDefinition();
        CompletableFuture<String> urlSuffixFuture = new CompletableFuture<String>();
        String string = SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.title.preparing", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, freeDisplay, availablePort, forwardingServerProcessesLifetime, urlSuffixFuture, string, performInBackgroundOption){
            final /* synthetic */ ScreenForwardingTargetEnvironmentRequestBase this$0;
            final /* synthetic */ int $freeDisplay;
            final /* synthetic */ int $availablePort;
            final /* synthetic */ LifetimeDefinition $forwardingServerProcessesLifetime;
            final /* synthetic */ CompletableFuture<String> $urlSuffixFuture;
            {
                this.this$0 = $receiver;
                this.$freeDisplay = $freeDisplay;
                this.$availablePort = $availablePort;
                this.$forwardingServerProcessesLifetime = $forwardingServerProcessesLifetime;
                this.$urlSuffixFuture = $urlSuffixFuture;
                super(null, $super_call_param$1, false, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    Logger logger;
                    Logger $this$trace$iv = ScreenForwardingTargetEnvironmentRequestBase.access$getLogger$cp();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Starting forwarding tools...");
                    }
                    String urlSuffix = this.this$0.createServerProcesses(indicator, this.$freeDisplay, this.$availablePort, this.$forwardingServerProcessesLifetime.getLifetime());
                    Logger $this$trace$iv2 = ScreenForwardingTargetEnvironmentRequestBase.access$getLogger$cp();
                    boolean $i$f$trace2 = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl = false;
                        logger.trace("Forwarding tools started");
                    }
                    this.$urlSuffixFuture.complete(urlSuffix);
                }
                catch (Throwable t) {
                    this.$urlSuffixFuture.completeExceptionally(t);
                }
            }
        });
        Ref.ObjectRef forwardedPort = new Ref.ObjectRef();
        String urlSuffixResult = urlSuffixFuture.get();
        ApplicationKt.getApplication().invokeLater(() -> ScreenForwardingTargetEnvironmentRequestBase.prepareEnvironment$lambda$2(forwardedPort, availablePort, urlSuffixResult));
        ScreenForwardingTargetEnvironment targetEnvironment = new ScreenForwardingTargetEnvironment(this, freeDisplay, (Function0<Unit>)((Function0)() -> ScreenForwardingTargetEnvironmentRequestBase.prepareEnvironment$lambda$3(forwardingServerProcessesLifetime, forwardedPort)));
        this.environmentPrepared((TargetEnvironment)targetEnvironment, progressIndicator);
        return targetEnvironment;
    }

    @NotNull
    protected abstract String createServerProcesses(@NotNull ProgressIndicator var1, int var2, int var3, @NotNull Lifetime var4);

    private static final void prepareEnvironment$lambda$3$0(Ref.ObjectRef $forwardedPort) {
        block0: {
            ForwardedPort forwardedPort = (ForwardedPort)$forwardedPort.element;
            if (forwardedPort == null) break block0;
            ForwardedPort it = forwardedPort;
            boolean bl = false;
            GlobalPortForwardingManager.Companion.getInstance().removePort(it);
        }
    }

    private static final void prepareEnvironment$lambda$2(Ref.ObjectRef $forwardedPort, int $availablePort, String $urlSuffixResult) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Forwarding port " + $availablePort);
        }
        $forwardedPort.element = GlobalPortForwardingManager.forwardPort$default((GlobalPortForwardingManager)GlobalPortForwardingManager.Companion.getInstance(), (int)$availablePort, (PortType)PortType.NON_USER_TCP, (Set)SetsKt.setOf((Object)("screenForwardingWeb##" + $urlSuffixResult)), null, (int)8, null);
    }

    private static final Unit prepareEnvironment$lambda$3(LifetimeDefinition $forwardingServerProcessesLifetime, Ref.ObjectRef $forwardedPort) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)$forwardingServerProcessesLifetime, (boolean)false, (int)1, null);
        ApplicationKt.getApplication().invokeLater(() -> ScreenForwardingTargetEnvironmentRequestBase.prepareEnvironment$lambda$3$0($forwardedPort));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ScreenForwardingTargetEnvironmentRequestBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ScreenForwardingTargetEnvironmentRequestBase.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/screenForwarding/ScreenForwardingTargetEnvironmentRequestBase$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

