/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcFactory;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeSshAgentIpcFactory;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpcFactory;", "<init>", "()V", "exists", "", "key", "", "generateKey", "create", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "intellij.platform.backend.split"})
public final class WindowsNamedPipeSshAgentIpcFactory
implements SshAgentIpcFactory {
    @Override
    public boolean exists(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        WinNT.HANDLE handle = Kernel32.INSTANCE.CreateFile(key, -1073741820, 0, null, 3, 0, null);
        if (!Intrinsics.areEqual((Object)handle, (Object)WinNT.INVALID_HANDLE_VALUE)) {
            Kernel32.INSTANCE.CloseHandle(handle);
            return true;
        }
        int lastError = Kernel32.INSTANCE.GetLastError();
        if (lastError == 2) {
            return false;
        }
        throw new IOException("pipe " + key + ": failed to check existence, lastError=" + ErrorToolsKt.prettyHRESULT((int)lastError));
    }

    @Override
    @NotNull
    public String generateKey() {
        File file2 = FileUtilRt.generateRandomTemporaryPath((String)"saf", (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"generateRandomTemporaryPath(...)");
        File temporaryPath = file2;
        return "\\\\.\\pipe\\" + temporaryPath;
    }

    @Override
    @NotNull
    public SshAgentIpc create(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new WindowsNamedPipeAgentIpc(key);
    }
}

