/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeEditorImpl;
import com.jetbrains.ide.model.uiautomation.BeEditorScrollPaneCustomization;
import com.jetbrains.ide.model.uiautomation.BeKeyEvent;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ui.bedsl.extensions.BeControlExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizer;
import com.jetbrains.rdserver.ui.converters.BeConversionContext;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.EditorComponentImplConverterKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import com.jetbrains.rdserver.ui.converters.utils.ComponentPropertiesTrackerUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorImplHandler;", "", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rdserver/ui/converters/TrackOptions;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getTrackOptions", "()Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "bind", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "createBeEditorScrollPaneCustomization", "Lcom/jetbrains/ide/model/uiautomation/BeEditorScrollPaneCustomization;", "intellij.platform.backend.split"})
public final class EditorImplHandler {
    @NotNull
    private final TrackOptions trackOptions;
    @NotNull
    private final Lifetime lifetime;

    public EditorImplHandler(@NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.trackOptions = trackOptions;
        this.lifetime = lifetime;
    }

    @NotNull
    public final TrackOptions getTrackOptions() {
        return this.trackOptions;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final BeControl bind(@NotNull ClientAppSession session, @NotNull EditorEx editor) {
        BeEditorImpl beEditorImpl;
        EditorEx editorEx;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.trackOptions.getConversionSettings().getCanBeShared()) {
            EditorEx editorCopy = EditorComponentImplConverterKt.copyEditor(session, editor, this.lifetime);
            new EditorToEditorSynchronizer((Editor)editor, (Editor)editorCopy, this.lifetime).install();
            editorEx = editorCopy;
        } else {
            editorEx = editor;
        }
        EditorEx editorToBind = editorEx;
        TextControlId editorId = BackendEditorHost.bindEditor$default(BackendEditorHost.Companion.getInstance(session), (Editor)editorToBind, false, 2, null);
        BeEditorImpl $this$bind_u24lambda_u240 = beEditorImpl = new BeEditorImpl(editorId);
        boolean bl = false;
        $this$bind_u24lambda_u240.getSettings().set((Object)EditorComponentImplConverterKt.access$toBeSettings(editorToBind));
        $this$bind_u24lambda_u240.getContextMenuGroupId().set((Object)editorToBind.getContextMenuGroupId());
        $this$bind_u24lambda_u240.getScrollPaneCustomization().set((Object)this.createBeEditorScrollPaneCustomization(editorToBind));
        JComponent jComponent = editorToBind.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        ComponentPropertiesTrackerUtil.trackComponentVisibleProperty$default(ComponentPropertiesTrackerUtil.INSTANCE, jComponent, this.trackOptions, (BeControl)$this$bind_u24lambda_u240, this.lifetime, null, 8, null);
        if (this.trackOptions.getConversionSettings().getConversionContext() == BeConversionContext.LUX) {
            JComponent jComponent2 = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getContentComponent(...)");
            JComponent component = jComponent2;
            BeControlExtensionsKt.bindFocusBothWays((BeControl)((BeControl)$this$bind_u24lambda_u240), (Lifetime)this.lifetime, (Component)component);
            $this$bind_u24lambda_u240.getTransferAllKeyEvents().set((Object)true);
            $this$bind_u24lambda_u240.getKeyEvent().advise(this.lifetime, arg_0 -> EditorImplHandler.bind$lambda$0$0(component, arg_0));
        }
        return (BeControl)beEditorImpl;
    }

    private final BeEditorScrollPaneCustomization createBeEditorScrollPaneCustomization(EditorEx $this$createBeEditorScrollPaneCustomization) {
        BeEditorScrollPaneCustomization beEditorScrollPaneCustomization;
        Component leadingComponent = (Component)ClientProperty.get((Component)$this$createBeEditorScrollPaneCustomization.getScrollPane().getVerticalScrollBar(), (Key)DefaultScrollBarUI.LEADING);
        if (leadingComponent == null) {
            return null;
        }
        BeEditorScrollPaneCustomization $this$createBeEditorScrollPaneCustomization_u24lambda_u240 = beEditorScrollPaneCustomization = new BeEditorScrollPaneCustomization();
        boolean bl = false;
        $this$createBeEditorScrollPaneCustomization_u24lambda_u240.getVerticalLeadingComponent().set((Object)ConverterRegistryKt.toBeModel(leadingComponent, this.trackOptions, this.lifetime));
        return beEditorScrollPaneCustomization;
    }

    private static final Unit bind$lambda$0$0(JComponent $component, BeKeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KeyEvent keyEvent = EditorComponentImplConverterKt.toKeyEvent(it, $component);
        $component.dispatchEvent(keyEvent);
        return Unit.INSTANCE;
    }
}

