/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.notification;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationRouter;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHostKt;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/ui/notification/ControllerNotificationRouter;", "Lcom/intellij/notification/NotificationRouter;", "<init>", "()V", "routeNotification", "", "notification", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nControllerNotificationRouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControllerNotificationRouter.kt\ncom/jetbrains/rdserver/ui/notification/ControllerNotificationRouter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n13#2:42\n*S KotlinDebug\n*F\n+ 1 ControllerNotificationRouter.kt\ncom/jetbrains/rdserver/ui/notification/ControllerNotificationRouter\n*L\n39#1:42\n*E\n"})
public final class ControllerNotificationRouter
implements NotificationRouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean routeNotification(@NotNull Notification notification, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        ClientAppSession clientAppSession = UtilKt.getControllerSessionOrNull(ApplicationKt.getApplication());
        if (clientAppSession == null) {
            return false;
        }
        ClientAppSession controllerSession = clientAppSession;
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            LOG.warn("ClientId might be missing.Notification is trying to be shown under local ClientId in RD mode", (Throwable)new Exception());
        }
        ClientId.Companion.withExplicitClientId(controllerSession.getClientId(), () -> ControllerNotificationRouter.routeNotification$lambda$0(project, controllerSession, notification));
        return true;
    }

    private static final Unit routeNotification$lambda$0(Project $project, ClientAppSession $controllerSession, Notification $notification) {
        ClientSession session;
        Project project = $project;
        ClientSession clientSession = session = project != null ? (ClientSession)UtilKt.getControllerSessionOrNull(project) : (ClientSession)$controllerSession;
        if (session != null) {
            BackendNotificationsHostKt.notifyClient($notification, session);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ControllerNotificationRouter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/ui/notification/ControllerNotificationRouter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

