/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.ShowingContainer;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonListener;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.PositionTracker;
import com.jetbrains.ide.model.uiautomation.BeBehaviorControl;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BePosition;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.ide.model.BeBalloon;
import com.jetbrains.rd.ide.model.BeEditorAnchor;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionEditorAnchorContext;
import com.jetbrains.rd.ide.model.BePopupPositionEditorContext;
import com.jetbrains.rd.ide.model.BePopupPositionEditorGutterContext;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.ui.bedsl.util.BeUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.ui.BeBackendContextProvider;
import com.jetbrains.rdserver.ui.converters.BeConversionContext;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import com.jetbrains.rdserver.ui.popup.BackendPopupModelHost;
import com.jetbrains.rdserver.ui.popup.settings.RdBalloonSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010'2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010(\u001a\u00020)H\u0002J*\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000b2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010'2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0014H\u0016J\b\u00103\u001a\u00020\u001cH\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0018H\u0002J\b\u00106\u001a\u00020\u001cH\u0016J\u0010\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0010\u00108\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0018H\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u0018H\u0016J\b\u0010;\u001a\u00020\u0018H\u0016J\b\u0010<\u001a\u00020\u0018H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J\u0012\u0010>\u001a\u00020\u001c2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J\b\u0010A\u001a\u00020\u001cH\u0016J\b\u0010B\u001a\u00020\u001cH\u0016J\u0016\u0010B\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'H\u0016J\u0010\u0010C\u001a\u00020\u001c2\b\u0010D\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/jetbrains/rdserver/ui/popup/RdBalloon;", "Lcom/intellij/openapi/ui/popup/Balloon;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "settings", "Lcom/jetbrains/rdserver/ui/popup/settings/RdBalloonSettings;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rdserver/ui/popup/settings/RdBalloonSettings;)V", "beBalloons", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "", "Lcom/jetbrains/rd/ide/model/BeBalloon;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "balloonRdMapId", "balloonBeModel", "myPopupListeners", "", "Lcom/intellij/openapi/ui/popup/JBPopupListener;", "myOnClickListener", "Ljava/awt/event/ActionListener;", "isShown", "", "showingContainer", "Lcom/intellij/ide/ui/ShowingContainer;", "show", "", "target", "Lcom/intellij/ui/awt/RelativePoint;", "preferredPosition", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "pane", "Ljavax/swing/JLayeredPane;", "showInCenterOf", "component", "Ljavax/swing/JComponent;", "tracker", "Lcom/intellij/util/ui/PositionTracker;", "getBalloonListener", "Lcom/intellij/openapi/ui/popup/BalloonListener;", "enrichContext", "beBalloon", "getPreferredSize", "Ljava/awt/Dimension;", "setBounds", "bounds", "Ljava/awt/Rectangle;", "addListener", "listener", "fireBeforeShown", "fireOnClosed", "isOk", "hide", "ok", "hideAndDispose", "setAnimationEnabled", "enabled", "wasFadedIn", "wasFadedOut", "isDisposed", "setTitle", "title", "", "dispose", "revalidate", "setOnClickListener", "onClickListener", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nRdBalloon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdBalloon.kt\ncom/jetbrains/rdserver/ui/popup/RdBalloon\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n67#2,4:317\n67#2,4:322\n67#2,4:326\n67#2,4:330\n13#2:334\n1#3:321\n*S KotlinDebug\n*F\n+ 1 RdBalloon.kt\ncom/jetbrains/rdserver/ui/popup/RdBalloon\n*L\n158#1:317,4\n144#1:322,4\n148#1:326,4\n150#1:330,4\n54#1:334\n*E\n"})
public final class RdBalloon
implements Balloon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final RdBalloonSettings settings;
    @NotNull
    private final IMutableViewableMap<Integer, BeBalloon> beBalloons;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final Lifetime lifetime;
    private final int balloonRdMapId;
    @Nullable
    private BeBalloon balloonBeModel;
    @NotNull
    private final Collection<JBPopupListener> myPopupListeners;
    @Nullable
    private ActionListener myOnClickListener;
    private boolean isShown;
    @Nullable
    private ShowingContainer showingContainer;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AtomicInteger idCounter;

    public RdBalloon(@NotNull ClientAppSession session, @NotNull RdBalloonSettings settings) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.session = session;
        this.settings = settings;
        this.beBalloons = BackendPopupModelHost.Companion.getInstance(this.session).getUiModel().getBeBalloons();
        this.lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)BackendPopupModelHost.Companion.getInstance(this.session)));
        this.lifetime = this.lifetimeDefinition.getLifetime();
        this.balloonRdMapId = idCounter.incrementAndGet();
        this.myPopupListeners = new CopyOnWriteArraySet();
    }

    public void show(@Nullable RelativePoint target, @Nullable Balloon.Position preferredPosition) {
        this.show((PositionTracker<Balloon>)((PositionTracker)new PositionTracker.Static(target)), preferredPosition);
    }

    public void show(@Nullable JLayeredPane pane) {
        JLayeredPane jLayeredPane = pane;
        Intrinsics.checkNotNull((Object)jLayeredPane);
        this.show(new RelativePoint((Component)jLayeredPane, new Point(0, 0)), Balloon.Position.above);
    }

    public void showInCenterOf(@Nullable JComponent component) {
        JComponent jComponent = component;
        Intrinsics.checkNotNull((Object)jComponent);
        Dimension size = jComponent.getSize();
        this.show(new RelativePoint((Component)component, new Point(size.width / 2, size.height / 2)), Balloon.Position.above);
    }

    public void show(@Nullable PositionTracker<Balloon> tracker, @Nullable Balloon.Position preferredPosition) {
        Project project;
        logger.trace("called show() method");
        if (this.settings.getContent().getClientProperty(InfoAndProgressPanel.FAKE_BALLOON) != null) {
            logger.trace("abort showing: fake balloon shouldn't be shown");
            return;
        }
        if (this.settings.getContent().getClientProperty(NotificationsManagerImpl.NOTIFICATION_BALLOON_FLAG) != null) {
            logger.trace("abort showing: notification balloon shouldn't be shown");
            return;
        }
        if (this.isShown) {
            logger.trace("abort showing: balloon has been already shown");
            return;
        }
        Object object = tracker;
        boolean bl = object != null && (object = object.getComponent()) != null ? !((Component)object).isVisible() : false;
        if (bl) {
            logger.trace("abort showing: parent component is hidden");
            return;
        }
        this.fireBeforeShown();
        this.isShown = true;
        Object object2 = tracker;
        if (object2 != null && (object2 = object2.getComponent()) != null) {
            Object component = object2;
            boolean bl2 = false;
            DataContext dataContext = DataManager.getInstance().getDataContext(component);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            project = DataContextKt.getProject((DataContext)dataContext);
        } else {
            project = null;
        }
        Project project2 = project;
        ShowingContainer showingContainer = this.showingContainer = ShowingContainer.Companion.getInstance(project2);
        if (showingContainer != null) {
            showingContainer.add((Component)this.settings.getContent());
        }
        BeBehaviorControl content = new BeBehaviorControl(ConverterRegistryKt.toBeModel(this.settings.getContent(), new TrackOptions(this.session, false, null, null, false, null, null, null, false, null, BeConversionContext.POPUP, 1022, null), this.lifetime));
        BeBalloon newBeBalloon = new BeBalloon((BeControl)content, this.settings.toBeModel());
        this.enrichContext(newBeBalloon, tracker, preferredPosition);
        PermittedModalityProtocolEntities permittedModalityProtocolEntities = PermittedModalityProtocolEntities.Companion.getInstance();
        RdBindableBase rdBindableBase = (RdBindableBase)newBeBalloon;
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        permittedModalityProtocolEntities.setModalityForPumping(this.lifetime, rdBindableBase, modalityState);
        this.balloonBeModel = newBeBalloon;
        newBeBalloon.getHideWithResult().advise(this.lifetime, arg_0 -> RdBalloon.show$lambda$1(this, arg_0));
        this.beBalloons.adviseAddRemove(this.lifetime, (arg_0, arg_1, arg_2) -> RdBalloon.show$lambda$2(this, arg_0, arg_1, arg_2));
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl3 = false;
            logger.trace("add balloon with id=" + this.balloonRdMapId + " to rdMap");
        }
        ((Map)this.beBalloons).put(this.balloonRdMapId, newBeBalloon);
        newBeBalloon.getUpdateLayout().fire((Object)Unit.INSTANCE);
        this.getBalloonListener().balloonShown((Balloon)this);
    }

    private final BalloonListener getBalloonListener() {
        return (BalloonListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BalloonListener.TOPIC);
    }

    private final void enrichContext(BeBalloon beBalloon, PositionTracker<Balloon> tracker, Balloon.Position preferredPosition) {
        RelativePoint relativePoint = tracker;
        if (relativePoint == null || (relativePoint = relativePoint.recalculateLocation((Object)this)) == null) {
            return;
        }
        RelativePoint location = relativePoint;
        BePosition bePosition = BeUtil.Companion.toBePosition(preferredPosition);
        Component trackerComponent = tracker instanceof PositionTracker.Static ? location.getOriginalComponent() : tracker.getComponent();
        Component component = trackerComponent;
        if (component instanceof EditorComponentImpl) {
            BePopupPositionContext pointContext = BeBackendContextProvider.Companion.getPointContext$default(BeBackendContextProvider.Companion, this.session, location, null, null, 8, null);
            if (pointContext instanceof BePopupPositionEditorContext) {
                beBalloon.getContext().set((Object)pointContext);
            } else {
                BePopupPositionEditorContext bePopupPositionEditorContext;
                EditorImpl editorImpl = ((EditorComponentImpl)trackerComponent).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
                EditorImpl editor = editorImpl;
                TextControlId textControlId = BackendEditorHost.Companion.textControlIdForSession((Editor)editor, this.session);
                if (textControlId == null) {
                    return;
                }
                TextControlId editorId = textControlId;
                VisualPosition visualPosition = (VisualPosition)editor.getUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION);
                if (visualPosition == null) {
                    bePopupPositionEditorContext = new BePopupPositionEditorContext(editorId, bePosition);
                } else {
                    LogicalPosition logicalPosition;
                    LogicalPosition logicalPosition2 = editor.visualToLogicalPosition(visualPosition);
                    Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"visualToLogicalPosition(...)");
                    LogicalPosition $this$enrichContext_u24lambda_u240 = logicalPosition = logicalPosition2;
                    boolean bl = false;
                    BeEditorAnchor anchor = new BeEditorAnchor($this$enrichContext_u24lambda_u240.line, $this$enrichContext_u24lambda_u240.column, $this$enrichContext_u24lambda_u240.leansForward);
                    bePopupPositionEditorContext = (BePopupPositionEditorContext)new BePopupPositionEditorAnchorContext(anchor, editorId, bePosition);
                }
                BePopupPositionEditorContext context = bePopupPositionEditorContext;
                beBalloon.getContext().set((Object)context);
            }
        } else if (component instanceof EditorGutterComponentEx) {
            EditorEx editorId = ((EditorGutterComponentEx)trackerComponent).getEditor();
            EditorImpl editorImpl = editorId instanceof EditorImpl ? (EditorImpl)editorId : null;
            if (editorImpl == null) {
                return;
            }
            EditorImpl editor = editorImpl;
            TextControlId textControlId = BackendEditorHost.Companion.textControlIdForSession((Editor)editor, this.session);
            if (textControlId == null) {
                return;
            }
            TextControlId editorId2 = textControlId;
            int line = editor.xyToLogicalPosition((Point)location.getOriginalPoint()).line;
            BePopupPositionEditorGutterContext context = new BePopupPositionEditorGutterContext(line, 0, editorId2, bePosition, 2, null);
            beBalloon.getContext().set((Object)context);
        } else {
            BePopupPositionContext context = BeBackendContextProvider.Companion.getPointContext$default(BeBackendContextProvider.Companion, this.session, location, null, bePosition, 4, null);
            if (context != null) {
                beBalloon.getContext().set((Object)context);
            }
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public void setBounds(@Nullable Rectangle bounds) {
    }

    public void addListener(@NotNull JBPopupListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myPopupListeners.add(listener2);
    }

    private final void fireBeforeShown() {
        for (JBPopupListener listener2 : this.myPopupListeners) {
            listener2.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
    }

    private final void fireOnClosed(boolean isOk) {
        for (JBPopupListener listener2 : this.myPopupListeners) {
            listener2.onClosed(new LightweightWindowEvent((LightweightWindow)this, isOk));
        }
    }

    public void hide() {
        logger.trace("called hide() method");
        this.hideAndDispose(false);
    }

    public void hide(boolean ok) {
        logger.trace("called hide(ok=" + ok + ") method");
        this.hideAndDispose(ok);
    }

    private final void hideAndDispose(boolean isOk) {
        logger.trace("called hideAndDispose(isOk=" + isOk + ")");
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)this.lifetimeDefinition))) {
            logger.trace("performing hideAndDispose(...) rejected: lifetime is dead");
            return;
        }
        logger.trace("performing hideAndDispose(...): lifetime is alive");
        this.isShown = false;
        ShowingContainer showingContainer = this.showingContainer;
        if (showingContainer != null) {
            showingContainer.remove((Component)this.settings.getContent());
        }
        logger.trace("killing lifetime");
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        this.fireOnClosed(isOk);
        logger.trace("removing balloon with id=" + this.balloonRdMapId + " from rdMap");
        this.beBalloons.remove((Object)this.balloonRdMapId);
        Disposer.dispose((Disposable)((Disposable)this));
    }

    public void setAnimationEnabled(boolean enabled) {
    }

    public boolean wasFadedIn() {
        return this.isShown;
    }

    public boolean wasFadedOut() {
        return RLifetimeKt.isAlive((Lifetime)this.lifetime);
    }

    public boolean isDisposed() {
        return !RLifetimeKt.isAlive((Lifetime)this.lifetime);
    }

    public void setTitle(@Nullable String title) {
        this.settings.setTitle(title);
    }

    public void dispose() {
        this.hideAndDispose(false);
    }

    public void revalidate() {
        block0: {
            BeBalloon beBalloon = this.balloonBeModel;
            if (beBalloon == null || (beBalloon = beBalloon.getUpdateLayout()) == null) break block0;
            beBalloon.fire((Object)Unit.INSTANCE);
        }
    }

    public void revalidate(@NotNull PositionTracker<Balloon> tracker) {
        block0: {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            BeBalloon beBalloon = this.balloonBeModel;
            if (beBalloon == null || (beBalloon = beBalloon.getUpdateLayout()) == null) break block0;
            beBalloon.fire((Object)Unit.INSTANCE);
        }
    }

    public final void setOnClickListener(@Nullable ActionListener onClickListener) {
        this.myOnClickListener = onClickListener;
    }

    private static final Unit show$lambda$1(RdBalloon this$0, boolean it) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("handle hideWithResult signal, come from thin client. result=" + it);
        }
        this$0.hideAndDispose(it);
        return Unit.INSTANCE;
    }

    private static final Unit show$lambda$2(RdBalloon this$0, AddRemove eventType, int rdMapId, BeBalloon beBalloon) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)beBalloon, (String)"beBalloon");
        Logger $this$trace$iv = RdBalloon.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("caught `my balloon added/removed from rdMap` event. EventType=" + eventType + ", added/removed balloon id=" + rdMapId);
        }
        if (rdMapId == this$0.balloonRdMapId && eventType == AddRemove.Remove) {
            $this$trace$iv = RdBalloon.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("handle `my balloon removed from rdMap` event. Removed balloon id=" + rdMapId);
            }
            this$0.hideAndDispose(false);
        } else {
            RdBalloon.logger.trace("ignore not interesting event");
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdBalloon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RdBalloon.logger = logger;
        idCounter = new AtomicInteger();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/ui/popup/RdBalloon$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

