/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.customization.splitMode;

import com.intellij.CommonBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Restarter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.unattendedHost.customization.SplitModeCustomization;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterSplitModeManager;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "runAppInSplitMode", "", "project", "Lcom/intellij/openapi/project/Project;", "performRestart", "showCannotRestartDialog", "showConfirmationDialog", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEnterSplitModeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnterSplitModeAction.kt\ncom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterSplitModeManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n23#2:103\n*S KotlinDebug\n*F\n+ 1 EnterSplitModeAction.kt\ncom/jetbrains/rdserver/unattendedHost/customization/splitMode/EnterSplitModeManager\n*L\n32#1:103\n*E\n"})
public final class EnterSplitModeManager {
    @NotNull
    public static final EnterSplitModeManager INSTANCE;
    @NotNull
    private static final Logger logger;

    private EnterSplitModeManager() {
    }

    public final void runAppInSplitMode(@Nullable Project project) {
        logger.info("Run app in Split mode action");
        if (SplitModeCustomization.Companion.getInstance().isFrontendStartedFromBackend()) {
            logger.info("Application is running in Split Mode already. Skip restart in Split Mode action.");
            return;
        }
        this.performRestart(project);
    }

    private final void performRestart(Project project) {
        logger.info("Perform application restart to launch in Split Mode");
        if (!Restarter.isSupported()) {
            this.showCannotRestartDialog(project);
            return;
        }
        if (!this.showConfirmationDialog(project)) {
            return;
        }
        Restarter.setMainAppArgs((List)CollectionsKt.listOf((Object)"splitMode"));
        ApplicationKt.getApplication().invokeLater(EnterSplitModeManager::performRestart$lambda$0);
    }

    private final void showCannotRestartDialog(Project project) {
        String title = SplitBackendBundle.INSTANCE.message("widget.EnterSplitMode.text", new Object[0]);
        String message = StringsKt.trimIndent((String)SplitBackendBundle.INSTANCE.message(PluginManagerCore.isRunningFromSources() ? "action.EnterSplitMode.restart.error.run.from.sources.message" : "action.EnterSplitMode.restart.error.run.from.launcher.message", new Object[0]));
        String okText = CommonBundle.getOkButtonText();
        MessagesService messagesService = MessagesService.Companion.getInstance();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNull((Object)okText);
        stringArray[0] = okText;
        MessagesService.showMessageDialog$default((MessagesService)messagesService, (Project)project, null, (String)message, (String)title, (String[])stringArray, (int)0, (int)0, (Icon)UIUtil.getWarningIcon(), null, (boolean)true, null, (int)1122, null);
    }

    private final boolean showConfirmationDialog(Project project) {
        String title = SplitBackendBundle.INSTANCE.message("widget.EnterSplitMode.text", new Object[0]);
        String message = StringsKt.trimIndent((String)SplitBackendBundle.INSTANCE.message("action.EnterSplitMode.restart.application.confirmation.message", new Object[0]));
        return Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static final void performRestart$lambda$0() {
        ApplicationKt.getApplication().exit(false, true, true);
    }

    static {
        EnterSplitModeManager $this$thisLogger$iv = INSTANCE = new EnterSplitModeManager();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(EnterSplitModeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EnterSplitModeManager.logger = logger;
    }
}

