/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.undo;

import com.intellij.ide.impl.UndoRemoteBehaviorService;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.RdAbstractUndoRequest;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdStackSizeItem;
import com.jetbrains.rd.ide.model.RdUndoRedoRequest;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.platform.codeWithMe.undo.RdAbstractUndoManager;
import com.jetbrains.rd.platform.codeWithMe.undo.RdUndoUtilsKt;
import com.jetbrains.rdserver.fileEditors.BackendFileEditorHost;
import com.jetbrains.rdserver.requests.RequestExecutionContext;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 02\u00020\u0001:\u00010B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0012\u00a2\u0006\u0004\b\u0004\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J%\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ \u0010 \u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020!H\u0002J*\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u001a\u0010/\u001a\u00020-2\b\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020!H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rdserver/undo/BackendUndoManager;", "Lcom/jetbrains/rd/platform/codeWithMe/undo/RdAbstractUndoManager;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "<init>", "(Lcom/intellij/openapi/components/ComponentManager;)V", "()V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isFrontendUndoRequestProcessing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isFrontendRequestExecuting", "getFileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "docRef", "Lcom/intellij/openapi/command/undo/DocumentReference;", "frontendRequestExecutionStarted", "", "frontendRequestExecutionStarted$intellij_platform_backend_split", "frontendRequestExecutionFinished", "frontendRequestExecutionFinished$intellij_platform_backend_split", "handleFrontendRequest", "context", "Lcom/jetbrains/rdserver/requests/RequestExecutionContext;", "changeScope", "Lcom/jetbrains/rd/ide/requests/ChangeScope;", "request", "Lcom/jetbrains/rd/ide/model/RdAbstractUndoRequest;", "handleFrontendRequest$intellij_platform_backend_split", "handleUndoRedoRequest", "Lcom/jetbrains/rd/ide/model/RdUndoRedoRequest;", "reportUndoCorruption", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "errorMessage", "", "getFileEditor", "sameStackSizes", "", "fileId", "frontendRequest", "backendUndoStackSize", "", "backendRedoStackSize", "getIndex", "Companion", "intellij.platform.backend.split"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nBackendUndoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendUndoManager.kt\ncom/jetbrains/rdserver/undo/BackendUndoManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,192:1\n777#2:193\n873#2,2:194\n363#2,7:197\n1#3:196\n13#4:204\n*S KotlinDebug\n*F\n+ 1 BackendUndoManager.kt\ncom/jetbrains/rdserver/undo/BackendUndoManager\n*L\n94#1:193\n94#1:194,2\n184#1:197,7\n29#1:204\n*E\n"})
public final class BackendUndoManager
extends RdAbstractUndoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isFrontendUndoRequestProcessing = new AtomicBoolean();
    @NotNull
    private final AtomicBoolean isFrontendRequestExecuting = new AtomicBoolean();
    @NotNull
    private static final Logger LOG;

    public BackendUndoManager(@Nullable ComponentManager componentManager) {
        super(componentManager);
    }

    private BackendUndoManager() {
        this((ComponentManager)null);
    }

    private BackendUndoManager(Project project) {
        this((ComponentManager)project);
    }

    @Nullable
    public RdFileId getFileId(@NotNull ClientAppSession session, @NotNull DocumentReference docRef) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
        return Companion.getFileId(session, docRef);
    }

    public final void frontendRequestExecutionStarted$intellij_platform_backend_split() {
        this.isFrontendRequestExecuting.set(true);
    }

    public final void frontendRequestExecutionFinished$intellij_platform_backend_split() {
        this.isFrontendRequestExecuting.set(false);
    }

    public final void handleFrontendRequest$intellij_platform_backend_split(@NotNull RequestExecutionContext context, @NotNull ChangeScope changeScope, @NotNull RdAbstractUndoRequest request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"changeScope");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof RdUndoRedoRequest) {
            this.handleUndoRedoRequest(context, changeScope, (RdUndoRedoRequest)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleUndoRedoRequest(RequestExecutionContext context, ChangeScope changeScope, RdUndoRedoRequest request) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Ref.ObjectRef errorMessage = new Ref.ObjectRef();
        boolean isUndo = request.isUndo();
        FileEditor fileEditor = this.getFileEditor(context, request);
        Iterator iterator = this.getDocRefs(context.getAppSession(), fileEditor);
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RdAbstractUndoManager.DocRefWithId it = (RdAbstractUndoManager.DocRefWithId)element$iv$iv;
            boolean bl = false;
            if (!request.getFileIds().contains(it.getFileId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List docRefs = (List)destination$iv$iv;
        if (!this.isUndoRedoAvailableUnsafe(fileEditor, isUndo)) {
            iterator = docRefs.iterator();
            while (iterator.hasNext()) {
                fileId = ((RdAbstractUndoManager.DocRefWithId)iterator.next()).component1();
                changeScope.pushChange((RdPatchItem)RdUndoUtilsKt.undoCorruptionItem((RdFileId)fileId));
            }
            errorMessage.element = "undo/redo not available";
        } else {
            this.isFrontendUndoRequestProcessing.set(true);
            try {
                this.undoOrRedo(fileEditor, isUndo);
            }
            finally {
                this.isFrontendUndoRequestProcessing.set(false);
            }
            if (UndoRemoteBehaviorService.debugExperimentalFrontendUndo()) {
                LOG.warn(this.dumpState(fileEditor, "debug handleUndoRedoRequest"));
            }
            BackendUndoManager.handleUndoRedoRequest$pushStackSizeItem(this, request, (Ref.ObjectRef<String>)errorMessage, changeScope, null, null);
            for (RdAbstractUndoManager.DocRefWithId docRefWithId : docRefs) {
                fileId = docRefWithId.component1();
                DocumentReference docRef = docRefWithId.component2();
                BackendUndoManager.handleUndoRedoRequest$pushStackSizeItem(this, request, (Ref.ObjectRef<String>)errorMessage, changeScope, fileId, docRef);
            }
        }
        if (errorMessage.element != null) {
            this.reportUndoCorruption(fileEditor, (String)errorMessage.element);
        }
    }

    private final void reportUndoCorruption(FileEditor fileEditor, String errorMessage) {
        LOG.error("undo/redo stacks are out of sync\n" + errorMessage + "\n" + this.dumpState(fileEditor, "backend corruption"));
    }

    private final FileEditor getFileEditor(RequestExecutionContext context, RdUndoRedoRequest request) {
        Object v0;
        RdFileEditorId fileEditorId;
        block4: {
            fileEditorId = request.getFileEditorId();
            if (fileEditorId == null) {
                return null;
            }
            Iterable iterable = context.getAppSession().getProjectSessions();
            for (Object t : iterable) {
                ClientProjectSession it = (ClientProjectSession)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProject(), (Object)this.getProject())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        ClientProjectSession projectSession = v0;
        if (!(projectSession != null)) {
            boolean bl = false;
            String string = "no project session found";
            throw new IllegalArgumentException(string.toString());
        }
        FileEditor fileEditor = BackendFileEditorHost.Companion.getInstance(projectSession).getEditor(fileEditorId);
        if (!(fileEditor != null)) {
            boolean bl = false;
            String string = "no fileEditor found";
            throw new IllegalArgumentException(string.toString());
        }
        return fileEditor;
    }

    private final boolean sameStackSizes(RdFileId fileId, RdUndoRedoRequest frontendRequest, int backendUndoStackSize, int backendRedoStackSize) {
        int index = this.getIndex(fileId, frontendRequest);
        if (index == -1) {
            return true;
        }
        return backendUndoStackSize == ((Number)frontendRequest.getUndoStackSizes().get(index)).intValue() && backendRedoStackSize == ((Number)frontendRequest.getRedoStackSizes().get(index)).intValue();
    }

    private final int getIndex(RdFileId fileId, RdUndoRedoRequest request) {
        int index;
        block4: {
            int n;
            if (fileId == null) {
                return 0;
            }
            List $this$indexOfFirst$iv = request.getFileIds();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                RdFileId it = (RdFileId)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)fileId)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return -1;
        }
        return index + 1;
    }

    private static final void handleUndoRedoRequest$pushStackSizeItem(BackendUndoManager this$0, RdUndoRedoRequest $request, Ref.ObjectRef<String> errorMessage, ChangeScope $changeScope, RdFileId fileId, DocumentReference docRef) {
        RdStackSizeItem rdStackSizeItem;
        int redoSize;
        int undoSize = this$0.getStackSize(docRef, true);
        boolean sizeMatch = this$0.sameStackSizes(fileId, $request, undoSize, redoSize = this$0.getStackSize(docRef, false));
        if (sizeMatch) {
            rdStackSizeItem = new RdStackSizeItem(fileId, undoSize, redoSize);
        } else {
            String error = "stack size for " + fileId + " not match";
            errorMessage.element = errorMessage.element == null ? error : errorMessage.element + "\n" + error;
            rdStackSizeItem = RdUndoUtilsKt.undoCorruptionItem((RdFileId)fileId);
        }
        RdStackSizeItem sizeItem = rdStackSizeItem;
        $changeScope.pushChange((RdPatchItem)sizeItem);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendUndoManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/undo/BackendUndoManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/undo/BackendUndoManager;", "project", "Lcom/intellij/openapi/project/Project;", "getFileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "docRef", "Lcom/intellij/openapi/command/undo/DocumentReference;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendUndoManager getInstance(@Nullable Project project) {
            Project project2 = project;
            UndoManager manager = project2 == null ? UndoManagerImpl.getGlobalInstance() : UndoManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.undo.BackendUndoManager");
            return (BackendUndoManager)manager;
        }

        @Nullable
        public final RdFileId getFileId(@NotNull ClientAppSession session, @NotNull DocumentReference docRef) {
            VirtualFile file2;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)docRef, (String)"docRef");
            VirtualFile file3 = docRef.getFile();
            if (file3 != null) {
                return BackendVirtualFileSystemHostKt.bind$default(file3, session, false, 2, null);
            }
            Document document = docRef.getDocument();
            if (document != null && (file2 = FileDocumentManager.getInstance().getFile(document)) != null) {
                return BackendVirtualFileSystemHostKt.bind$default(file2, session, false, 2, null);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

