/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm;

import com.google.common.base.Joiner;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.liquibase.orm.LiquibaseGenerationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquibaseElementsNamesHelper {
    private final LiquibaseGenerationContext context;

    public LiquibaseElementsNamesHelper(LiquibaseGenerationContext context) {
        this.context = context;
    }

    public String foreignKeyConstraintName(String tableName, List<String> columnNames, EntityAttribute attribute) {
        return Optional.ofNullable(attribute).map(EntityAttribute::getForeignKey).map(ForeignKeyModel::getName).orElseGet(() -> this.foreignKeyConstraintName(tableName, columnNames));
    }

    @NotNull
    public String foreignKeyConstraintName(@NotNull String tableName, Collection<String> columnNames) {
        if (tableName == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(0);
        }
        String string = this.generateConstraintName("FK", tableName, "ON", columnNames);
        if (string == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String generateConstraintName(@Nullable String prefix, @NotNull String tableName, @Nullable String suffix, Collection<String> columnNames) {
        if (tableName == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(2);
        }
        int identifierMaxLength = this.context.getIdentifierMaxLength();
        Object result = "";
        if (StringUtil.isNotEmpty((String)prefix)) {
            result = (String)result + prefix + "_";
        }
        result = (String)result + DbIdentifierHelper.convertToClearValidIdentifier((String)tableName);
        if (!columnNames.isEmpty()) {
            result = (String)result + "_";
        }
        if (suffix != null) {
            result = (String)result + suffix + "_";
        }
        result = (String)result + this.processedAttrName(columnNames);
        String rawName = identifierMaxLength <= 0 || identifierMaxLength >= ((String)result).length() ? ((String)result).toUpperCase(Locale.ROOT) : this.getShortName(prefix, tableName, suffix, columnNames).toUpperCase(Locale.ROOT);
        String string = (String)JpaPluginProjectConfig.getState((Project)this.context.getProject()).indexCase.getConverter().apply(rawName);
        if (string == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String generateUniqueConstraintName(String tableName, LinkedHashSet<String> columnNames) {
        return this.generateConstraintName("UC", tableName, null, columnNames);
    }

    public String getAcronym(String name, int acronymLength) {
        StringBuilder acronym = new StringBuilder();
        for (String s : name.split("_")) {
            if (s.isEmpty()) continue;
            acronym.append(s.length() < acronymLength ? s : s.substring(0, acronymLength));
        }
        return acronym.toString().toUpperCase(Locale.ROOT);
    }

    private String getShortName(@Nullable String prefix, @Nullable String tableName, @Nullable String suffix, @NotNull Collection<String> columnNames) {
        int identifierMaxLength;
        if (columnNames == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(4);
        }
        ArrayList<String> nameElems = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            nameElems.add(prefix.replace("_", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            nameElems.add(tableName);
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            nameElems.add(suffix);
        }
        if (!columnNames.isEmpty()) {
            nameElems.add(this.processedAttrName(columnNames));
        }
        if (this.isInvalidIdentifierName(nameElems, identifierMaxLength = this.context.getIdentifierMaxLength())) {
            for (int i = 0; i < nameElems.size(); ++i) {
                String elemName = (String)nameElems.get(i);
                if (!elemName.contains("_")) continue;
                nameElems.set(i, elemName.replace("_", ""));
            }
        }
        while (this.isInvalidIdentifierName(nameElems, identifierMaxLength)) {
            int maxLength = StreamEx.of(nameElems).map(String::length).max(Integer::compareTo).orElse(0);
            for (int i = 0; i < nameElems.size(); ++i) {
                String elemName = (String)nameElems.get(i);
                int currElemLength = elemName.length();
                if (currElemLength >= maxLength) {
                    nameElems.set(i, elemName.substring(0, currElemLength - 1));
                    continue;
                }
                nameElems.set(i, elemName);
            }
        }
        StringBuilder sb = new StringBuilder(Joiner.on((String)"_").skipNulls().join(nameElems));
        if (sb.length() > identifierMaxLength) {
            sb.delete(identifierMaxLength, sb.length());
        }
        return sb.toString();
    }

    private boolean isInvalidIdentifierName(List<String> nameElems, int identifierMaxLength) {
        return this.shortNameLength(nameElems) > identifierMaxLength;
    }

    private int shortNameLength(List<String> name) {
        int length = 0;
        for (String elem : name) {
            length += elem.length() + 1;
        }
        return length - 1;
    }

    @NotNull
    private String processedAttrName(Collection<String> columnNames) {
        if (columnNames.isEmpty()) {
            return "";
        }
        List validColumnNames = ((StreamEx)StreamEx.of(columnNames).map(DbIdentifierHelper::convertToClearValidIdentifier).nonNull().distinct()).toList();
        if (validColumnNames.size() == 1) {
            String columnName = (String)validColumnNames.iterator().next();
            int idx = columnName.lastIndexOf(95);
            String string = StringUtil.endsWithIgnoreCase((String)columnName, (String)"_ID") ? columnName.substring(0, idx) : columnName;
            if (string == null) {
                LiquibaseElementsNamesHelper.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.getAcronym(StreamEx.of((Collection)validColumnNames).joining((CharSequence)"_"), 2);
        if (string == null) {
            LiquibaseElementsNamesHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/liquibase/orm/LiquibaseElementsNamesHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/liquibase/orm/LiquibaseElementsNamesHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "foreignKeyConstraintName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstraintName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processedAttrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyConstraintName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateConstraintName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

