/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm;

import com.intellij.jpa.jpb.model.core.model.dbprop.OfflineDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.util.CanceledProgressAction;
import com.intellij.jpa.jpb.model.core.util.HProgressManager;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.orm.LiquibaseCommandManager;
import com.intellij.liquibase.orm.LiquibaseCommandManagerKt;
import com.intellij.liquibase.orm.LiquibaseGenerationContext;
import com.intellij.liquibase.orm.LiquibaseGenerationContextRegistry;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/liquibase/orm/LiquibaseGenerateModelSnapshotHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbmsType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "outputFile", "", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "persistenceUnit", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/lang/String;Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbmsType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getOutputFile", "()Ljava/lang/String;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getPersistenceUnit", "testMode", "", "liquibaseCommandManager", "Lcom/intellij/liquibase/orm/LiquibaseCommandManager;", "run", "", "createDatabase", "Lliquibase/database/Database;", "context", "Lcom/intellij/liquibase/orm/LiquibaseGenerationContext;", "doRun", "Companion", "intellij.liquibase.orm"})
public final class LiquibaseGenerateModelSnapshotHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DbType dbmsType;
    @NotNull
    private final String outputFile;
    @NotNull
    private final OrmFramework ormFramework;
    @Nullable
    private final String persistenceUnit;
    private final boolean testMode;
    @NotNull
    private final LiquibaseCommandManager liquibaseCommandManager;

    public LiquibaseGenerateModelSnapshotHandler(@NotNull Project project, @NotNull DbType dbmsType, @NotNull String outputFile, @NotNull OrmFramework ormFramework, @Nullable String persistenceUnit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbmsType, (String)"dbmsType");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        this.project = project;
        this.dbmsType = dbmsType;
        this.outputFile = outputFile;
        this.ormFramework = ormFramework;
        this.persistenceUnit = persistenceUnit;
        this.testMode = ApplicationManager.getApplication().isUnitTestMode();
        this.liquibaseCommandManager = LiquibaseCommandManager.Companion.getInstance(this.project);
    }

    public /* synthetic */ LiquibaseGenerateModelSnapshotHandler(Project project, DbType dbType, String string, OrmFramework ormFramework, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(project, dbType, string, ormFramework, string2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbType getDbmsType() {
        return this.dbmsType;
    }

    @NotNull
    public final String getOutputFile() {
        return this.outputFile;
    }

    @NotNull
    public final OrmFramework getOrmFramework() {
        return this.ormFramework;
    }

    @Nullable
    public final String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        LiquibaseGenerationContext context = new LiquibaseGenerationContext(this.project, this.dbmsType, CollectionsKt.emptyList(), this.ormFramework, this.persistenceUnit, null, new String[0], 32, null);
        LiquibaseGenerationContextRegistry.INSTANCE.registerContext(context);
        try {
            if (this.testMode) {
                this.doRun(context);
            } else {
                HProgressManager.Companion.getInstance(this.project).runProcessWithCanceledProgressSynchronously((CanceledProgressAction)new CanceledProgressAction<Unit>(this, context){
                    private final String progressTitle;
                    final /* synthetic */ LiquibaseGenerateModelSnapshotHandler this$0;
                    final /* synthetic */ LiquibaseGenerationContext $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        String string = LiquibaseResourceBundle.message((String)"generate.liquibase.snapshot", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.progressTitle = string;
                    }

                    public String getProgressTitle() {
                        return this.progressTitle;
                    }

                    public void compute() {
                        LiquibaseGenerateModelSnapshotHandler.access$doRun(this.this$0, this.$context);
                    }
                });
            }
        }
        finally {
            LiquibaseGenerationContextRegistry.INSTANCE.unregisterContext(context);
        }
    }

    private final Database createDatabase(LiquibaseGenerationContext context) {
        String referenceUrl = "jpab?generationContext=" + context.getId();
        return LiquibaseCommandManager.createDatabase$default(this.liquibaseCommandManager, this.liquibaseCommandManager.createFileOpener(null, null), referenceUrl, null, null, null, context.getMainDbType(), false, 64, null);
    }

    private final void doRun(LiquibaseGenerationContext context) {
        ActionsKt.runReadAction(() -> LiquibaseGenerateModelSnapshotHandler.doRun$lambda$0(this, context));
    }

    private static final Unit doRun$lambda$0$0(LiquibaseGenerateModelSnapshotHandler this$0, LiquibaseGenerationContext $context) {
        Database intellijDatabase = this$0.createDatabase($context);
        this$0.liquibaseCommandManager.generateSnapshot(this$0.outputFile, intellijDatabase);
        return Unit.INSTANCE;
    }

    private static final Unit doRun$lambda$0(LiquibaseGenerateModelSnapshotHandler this$0, LiquibaseGenerationContext $context) {
        LiquibaseCommandManagerKt.runWithPluginClassLoader(() -> LiquibaseGenerateModelSnapshotHandler.doRun$lambda$0$0(this$0, $context));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doRun(LiquibaseGenerateModelSnapshotHandler $this, LiquibaseGenerationContext context) {
        $this.doRun(context);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/orm/LiquibaseGenerateModelSnapshotHandler$Companion;", "", "<init>", "()V", "fromOfflineDbProperties", "Lcom/intellij/liquibase/orm/LiquibaseGenerateModelSnapshotHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/OfflineDbProperties;", "outputFile", "", "readProperties", "Ljava/util/Properties;", "string", "intellij.liquibase.orm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiquibaseGenerateModelSnapshotHandler fromOfflineDbProperties(@NotNull Project project, @NotNull OrmFramework ormFramework, @NotNull OfflineDbProperties dbProperties, @NotNull String outputFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            String string = dbProperties.getUrl();
            Intrinsics.checkNotNull((Object)string);
            String params = StringsKt.removePrefix((String)string, (CharSequence)"jpab?");
            Properties properties = this.readProperties(params);
            String persistenceUnit = properties.getProperty("persistenceUnit");
            DbType dbType = dbProperties.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
            return new LiquibaseGenerateModelSnapshotHandler(project, dbType, outputFile, ormFramework, persistenceUnit);
        }

        private final Properties readProperties(String string) {
            String queryString = string;
            Properties properties = new Properties();
            CharSequence charSequence = queryString;
            Regex regex = new Regex("&");
            String string2 = System.getProperty("line.separator");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String string3 = string2;
            queryString = regex.replace(charSequence, string3);
            try {
                String string4 = URLDecoder.decode(queryString, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"decode(...)");
                queryString = string4;
                properties.load(new StringReader(queryString));
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to read properties from url", ioe);
            }
            return properties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

