/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.liquibase.orm.LiquibaseSnapshotWrapper;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/liquibase/orm/LiquibaseSnapshotHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findAllSnapshotFiles", "", "Lcom/intellij/liquibase/orm/LiquibaseSnapshotWrapper;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getDbShorName", "", "jsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSnapshotWrapper", "path", "Companion", "intellij.liquibase.orm"})
public final class LiquibaseSnapshotHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;

    public LiquibaseSnapshotHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<LiquibaseSnapshotWrapper> findAllSnapshotFiles(@NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Collection collection = FilenameIndex.getAllFilesByExt((Project)this.project, (String)"json", (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllFilesByExt(...)");
        Collection allJsonFiles = collection;
        List result = new ArrayList();
        for (VirtualFile jsonFile : allJsonFiles) {
            String dbShorName;
            Intrinsics.checkNotNull((Object)jsonFile);
            if (this.getDbShorName(jsonFile) == null) continue;
            result.add(new LiquibaseSnapshotWrapper(dbShorName, jsonFile));
        }
        return result;
    }

    public static /* synthetic */ Collection findAllSnapshotFiles$default(LiquibaseSnapshotHelper liquibaseSnapshotHelper, GlobalSearchScope globalSearchScope, int n, Object object) {
        if ((n & 1) != 0) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)liquibaseSnapshotHelper.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"allScope(...)");
            globalSearchScope = globalSearchScope2;
        }
        return liquibaseSnapshotHelper.findAllSnapshotFiles(globalSearchScope);
    }

    @Nullable
    public final String getDbShorName(@NotNull VirtualFile jsonFile) {
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        PsiFile psiFile = this.psiManager.findFile(jsonFile);
        JsonFile jsonFile2 = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
        if (jsonFile2 == null) {
            return null;
        }
        JsonFile psiFile2 = jsonFile2;
        JsonValue jsonValue = psiFile2.getTopLevelValue();
        JsonObject jsonObject = jsonValue instanceof JsonObject ? (JsonObject)jsonValue : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject topLevelValue = jsonObject;
        JsonProperty jsonProperty = topLevelValue.findProperty("snapshot");
        JsonValue jsonValue2 = jsonProperty != null ? jsonProperty.getValue() : null;
        JsonObject jsonObject2 = jsonValue2 instanceof JsonObject ? (JsonObject)jsonValue2 : null;
        if (jsonObject2 == null) {
            return null;
        }
        JsonObject snapshotValue = jsonObject2;
        JsonProperty jsonProperty2 = snapshotValue.findProperty("database");
        JsonValue jsonValue3 = jsonProperty2 != null ? jsonProperty2.getValue() : null;
        JsonObject jsonObject3 = jsonValue3 instanceof JsonObject ? (JsonObject)jsonValue3 : null;
        if (jsonObject3 == null) {
            return null;
        }
        JsonObject databaseValue = jsonObject3;
        JsonProperty jsonProperty3 = databaseValue.findProperty("shortName");
        JsonValue jsonValue4 = jsonProperty3 != null ? jsonProperty3.getValue() : null;
        JsonStringLiteral jsonStringLiteral = jsonValue4 instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue4 : null;
        if (jsonStringLiteral == null) {
            return null;
        }
        JsonStringLiteral dbShortName = jsonStringLiteral;
        if (Intrinsics.areEqual((Object)"intellijPsiClass", (Object)dbShortName.getValue())) {
            JsonProperty jsonProperty4 = snapshotValue.findProperty("metadata");
            JsonValue jsonValue5 = jsonProperty4 != null ? jsonProperty4.getValue() : null;
            JsonObject jsonObject4 = jsonValue5 instanceof JsonObject ? (JsonObject)jsonValue5 : null;
            JsonValue jsonValue6 = jsonObject4 != null && (jsonValue5 = jsonObject4.findProperty("generationContext")) != null ? jsonValue5.getValue() : null;
            JsonObject jsonObject5 = jsonValue6 instanceof JsonObject ? (JsonObject)jsonValue6 : null;
            JsonValue jsonValue7 = jsonObject5 != null && (jsonValue6 = jsonObject5.findProperty("dbmsType")) != null ? jsonValue6.getValue() : null;
            JsonStringLiteral jsonStringLiteral2 = jsonValue7 instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue7 : null;
            if (jsonStringLiteral2 == null) {
                return null;
            }
            JsonStringLiteral mainLiquibaseDbms = jsonStringLiteral2;
            return mainLiquibaseDbms.getValue();
        }
        return dbShortName.getValue();
    }

    @Nullable
    public final LiquibaseSnapshotWrapper createSnapshotWrapper(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String processedPath = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(processedPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jsonFile = virtualFile;
        String string2 = this.getDbShorName(jsonFile);
        if (string2 == null) {
            return null;
        }
        String dbShorName = string2;
        return new LiquibaseSnapshotWrapper(dbShorName, jsonFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/orm/LiquibaseSnapshotHelper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/orm/LiquibaseSnapshotHelper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.orm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiquibaseSnapshotHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiquibaseSnapshotHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LiquibaseSnapshotHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

