/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.action;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.liquibase.core.filter.LiquibaseChangeSetFilter;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.orm.LiquibaseUpdateProcess;
import com.intellij.liquibase.orm.LiquibaseUpdateResult;
import com.intellij.liquibase.orm.action.JpaLiquibaseUpdateProcess;
import com.intellij.liquibase.orm.action.filter.LiquibaseUpdateSuccessfulFilter;
import com.intellij.liquibase.orm.config.LogLevel;
import com.intellij.liquibase.orm.db.DasDatabaseFactory;
import com.intellij.liquibase.orm.gui.JpaRunContentExecutor;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import liquibase.ext.intellij.configuration.IdeaConfigurationValueProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010$\u001a\u00020%H\u0096@\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lcom/intellij/liquibase/orm/action/JpaLiquibaseUpdateProcess;", "Lcom/intellij/liquibase/orm/LiquibaseUpdateProcess;", "project", "Lcom/intellij/openapi/project/Project;", "myChangeLog", "Lcom/intellij/psi/PsiFile;", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "contexts", "", "labels", "logLevel", "Lcom/intellij/liquibase/orm/config/LogLevel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/liquibase/orm/config/LogLevel;)V", "getMyChangeLog", "()Lcom/intellij/psi/PsiFile;", "getDataStore", "()Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "getContexts", "()Ljava/lang/String;", "getLabels", "getLogLevel", "()Lcom/intellij/liquibase/orm/config/LogLevel;", "properties", "", "getProperties", "()Ljava/util/Map;", "changeLogFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChangeLogFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "getDbProperties", "()Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "getModule", "Lcom/intellij/openapi/module/Module;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeCommandLine", "Lcom/intellij/liquibase/orm/LiquibaseUpdateResult;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.liquibase.orm"})
final class JpaLiquibaseUpdateProcess
extends LiquibaseUpdateProcess {
    @NotNull
    private final PsiFile myChangeLog;
    @NotNull
    private final AbstractRdbmsStore dataStore;
    @Nullable
    private final String contexts;
    @Nullable
    private final String labels;
    @Nullable
    private final LogLevel logLevel;
    @NotNull
    private final VirtualFile changeLogFile;

    public JpaLiquibaseUpdateProcess(@NotNull Project project, @NotNull PsiFile myChangeLog, @NotNull AbstractRdbmsStore dataStore, @Nullable String contexts, @Nullable String labels, @Nullable LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myChangeLog, (String)"myChangeLog");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        super(project);
        this.myChangeLog = myChangeLog;
        this.dataStore = dataStore;
        this.contexts = contexts;
        this.labels = labels;
        this.logLevel = logLevel;
        VirtualFile virtualFile = this.myChangeLog.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        this.changeLogFile = virtualFile;
    }

    @NotNull
    public final PsiFile getMyChangeLog() {
        return this.myChangeLog;
    }

    @NotNull
    public final AbstractRdbmsStore getDataStore() {
        return this.dataStore;
    }

    @Override
    @Nullable
    public String getContexts() {
        return this.contexts;
    }

    @Override
    @Nullable
    public String getLabels() {
        return this.labels;
    }

    @Override
    @Nullable
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    @NotNull
    public Map<String, String> getProperties() {
        return MapsKt.plus(super.getProperties(), IdeaConfigurationValueProvider.Companion.getCONFIGS_MAP());
    }

    @Override
    @NotNull
    public VirtualFile getChangeLogFile() {
        return this.changeLogFile;
    }

    @Override
    @NotNull
    public DbProperties getDbProperties() {
        DbProperties dbProperties = DbProperties.prepareDbProperties((Project)this.getProject(), (DbProperties)this.dataStore.getDbProperties());
        Intrinsics.checkNotNullExpressionValue((Object)dbProperties, (String)"prepareDbProperties(...)");
        return dbProperties;
    }

    @Override
    @Nullable
    public Object getModule(@NotNull Continuation<? super Module> $completion) {
        return CoroutinesKt.readAction(() -> JpaLiquibaseUpdateProcess.getModule$lambda$0(this), $completion);
    }

    @Override
    @Nullable
    public Object executeCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Continuation<? super LiquibaseUpdateResult> $completion) {
        ProcessHandler processHandler = (ProcessHandler)new KillableProcessHandler(commandLine);
        new JpaRunContentExecutor(this.getProject(), processHandler).withTitle(LiquibaseResourceBundle.message((String)"tab.title.liquibase.update", (Object[])new Object[0])).withProcessAdapter(new ProcessAdapter(this){
            final /* synthetic */ JpaLiquibaseUpdateProcess this$0;
            {
                this.this$0 = $receiver;
            }

            public void processTerminated(ProcessEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AbstractRdbmsStore dataStore = this.this$0.getDataStore();
                    DasDatabaseFactory dasDatabaseFactory = DasDatabaseFactory.Companion.getInstance(this.this$0.getProject());
                    if (dasDatabaseFactory == null) break block0;
                    dasDatabaseFactory.refreshDataSource(dataStore, (Function1<? super Throwable, Unit>)((Function1)executeCommandLine.2::processTerminated$lambda$0));
                }
            }

            private static final Unit processTerminated$lambda$0(Throwable it) {
                return Unit.INSTANCE;
            }
        }).withIcon(AllIcons.Providers.Liquibase).withFilter(new LiquibaseUpdateSuccessfulFilter()).withFilter((Filter)new LiquibaseChangeSetFilter(this.getProject())).run();
        return new LiquibaseUpdateResult.Success("");
    }

    private static final Module getModule$lambda$0(JpaLiquibaseUpdateProcess this$0) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)this$0.myChangeLog);
        Intrinsics.checkNotNull((Object)module);
        return module;
    }
}

