/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui;

import com.intellij.liquibase.orm.gui.ChangeModel;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0017\u001a\u00020\u0010J\u0006\u0010\u0018\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/liquibase/orm/gui/AntagonistChangesCache;", "", "<init>", "()V", "tables", "Lcom/intellij/liquibase/orm/gui/AntagonistChangesCache$ChangeItem;", "getTables", "()Lcom/intellij/liquibase/orm/gui/AntagonistChangesCache$ChangeItem;", "sequences", "getSequences", "columns", "", "", "getColumns", "()Ljava/util/Map;", "add", "", "changeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "findOrCreateColumnChangeItem", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "findColumnChangeItem", "clear", "compact", "ChangeItem", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nAntagonistChangesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntagonistChangesCache.kt\ncom/intellij/liquibase/orm/gui/AntagonistChangesCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1915#2,2:97\n*S KotlinDebug\n*F\n+ 1 AntagonistChangesCache.kt\ncom/intellij/liquibase/orm/gui/AntagonistChangesCache\n*L\n56#1:97,2\n*E\n"})
public final class AntagonistChangesCache {
    @NotNull
    private final ChangeItem tables = new ChangeItem();
    @NotNull
    private final ChangeItem sequences = new ChangeItem();
    @NotNull
    private final Map<String, ChangeItem> columns = new LinkedHashMap();

    @NotNull
    public final ChangeItem getTables() {
        return this.tables;
    }

    @NotNull
    public final ChangeItem getSequences() {
        return this.sequences;
    }

    @NotNull
    public final Map<String, ChangeItem> getColumns() {
        return this.columns;
    }

    public final void add(@NotNull DefaultMutableTreeNode changeNode) {
        Intrinsics.checkNotNullParameter((Object)changeNode, (String)"changeNode");
        Object object = changeNode.getUserObject();
        ChangeModel changeModel = object instanceof ChangeModel ? (ChangeModel)object : null;
        if (changeModel == null) {
            return;
        }
        ChangeModel changeModel2 = changeModel;
        XmlTag xmlTag = changeModel2.getXmlTag();
        switch (changeModel2.getTagName()) {
            case "dropTable": {
                this.tables.addDropChange(changeNode);
                break;
            }
            case "createTable": {
                this.tables.addCreateChange(changeNode);
                break;
            }
            case "createSequence": {
                this.sequences.addCreateChange(changeNode);
                break;
            }
            case "dropSequence": {
                this.sequences.addDropChange(changeNode);
                break;
            }
            case "dropColumn": {
                ChangeItem changeItem = this.findOrCreateColumnChangeItem(xmlTag);
                if (changeItem != null) {
                    changeItem.addDropChange(changeNode);
                }
                break;
            }
            case "addColumn": {
                ChangeItem changeItem = this.findOrCreateColumnChangeItem(xmlTag);
                if (changeItem == null) break;
                changeItem.addCreateChange(changeNode);
                break;
            }
        }
    }

    private final ChangeItem findOrCreateColumnChangeItem(XmlTag xmlTag) {
        ChangeItem changeItem;
        XmlTag xmlTag2 = xmlTag;
        String tableName = xmlTag2 != null ? xmlTag2.getAttributeValue("tableName") : null;
        CharSequence charSequence = tableName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = tableName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            changeItem = this.columns.computeIfAbsent(string, arg_0 -> AntagonistChangesCache.findOrCreateColumnChangeItem$lambda$1(AntagonistChangesCache::findOrCreateColumnChangeItem$lambda$0, arg_0));
        } else {
            changeItem = null;
        }
        return changeItem;
    }

    @Nullable
    public final ChangeItem findColumnChangeItem(@Nullable XmlTag xmlTag) {
        ChangeItem changeItem;
        XmlTag xmlTag2 = xmlTag;
        String tableName = xmlTag2 != null ? xmlTag2.getAttributeValue("tableName") : null;
        CharSequence charSequence = tableName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = tableName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            changeItem = this.columns.get(string);
        } else {
            changeItem = null;
        }
        return changeItem;
    }

    public final void clear() {
        this.tables.clear();
        this.sequences.clear();
        this.columns.clear();
    }

    public final void compact() {
        this.tables.compact();
        this.sequences.compact();
        Iterable $this$forEach$iv = this.columns.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeItem it = (ChangeItem)element$iv;
            boolean bl = false;
            it.compact();
        }
    }

    private static final ChangeItem findOrCreateColumnChangeItem$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ChangeItem();
    }

    private static final ChangeItem findOrCreateColumnChangeItem$lambda$1(Function1 $tmp0, Object p0) {
        return (ChangeItem)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/liquibase/orm/gui/AntagonistChangesCache$ChangeItem;", "", "<init>", "()V", "createChanges", "", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getCreateChanges", "()Ljava/util/List;", "dropChanges", "getDropChanges", "addCreateChange", "", "path", "addDropChange", "getChanges", "", "isCreate", "", "clear", "compact", "isEmpty", "removeNode", "selectedNode", "intellij.liquibase.orm"})
    public static final class ChangeItem {
        @NotNull
        private final List<DefaultMutableTreeNode> createChanges = new ArrayList();
        @NotNull
        private final List<DefaultMutableTreeNode> dropChanges = new ArrayList();

        @NotNull
        public final List<DefaultMutableTreeNode> getCreateChanges() {
            return this.createChanges;
        }

        @NotNull
        public final List<DefaultMutableTreeNode> getDropChanges() {
            return this.dropChanges;
        }

        public final void addCreateChange(@NotNull DefaultMutableTreeNode path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.createChanges.add(path);
        }

        public final void addDropChange(@NotNull DefaultMutableTreeNode path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.dropChanges.add(path);
        }

        @NotNull
        public final List<DefaultMutableTreeNode> getChanges(boolean isCreate) {
            return isCreate ? this.createChanges : this.dropChanges;
        }

        public final void clear() {
            this.createChanges.clear();
            this.dropChanges.clear();
        }

        public final void compact() {
            if (this.createChanges.isEmpty() || this.dropChanges.isEmpty()) {
                this.clear();
            }
        }

        public final boolean isEmpty() {
            return this.createChanges.isEmpty() && this.dropChanges.isEmpty();
        }

        public final void removeNode(@NotNull DefaultMutableTreeNode selectedNode) {
            Intrinsics.checkNotNullParameter((Object)selectedNode, (String)"selectedNode");
            this.createChanges.remove(selectedNode);
            this.dropChanges.remove(selectedNode);
            if (this.createChanges.isEmpty() || this.dropChanges.isEmpty()) {
                this.clear();
            }
        }
    }
}

