/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.provider;

import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.liquibase.core.extension.LiquibaseFrameworkContextProvider;
import com.intellij.liquibase.orm.LiquibaseCommandManager;
import com.intellij.liquibase.orm.LiquibaseHelper;
import com.intellij.liquibase.orm.LiquibaseManager;
import com.intellij.liquibase.orm.action.quickfix.CreateDiffChangelogQuickFix;
import com.intellij.liquibase.orm.config.DatabaseMigrationConfig;
import com.intellij.liquibase.orm.config.LiquibaseChange;
import com.intellij.liquibase.orm.config.LiquibaseChangesConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/liquibase/orm/provider/LiquibaseSpringContextProvider;", "Lcom/intellij/liquibase/core/extension/LiquibaseFrameworkContextProvider;", "<init>", "()V", "isLiquibaseSupported", "", "project", "Lcom/intellij/openapi/project/Project;", "findMainChangeLogFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "changelogDirPatterns", "", "", "createChangelogQuickFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/codeInsight/daemon/quickFix/NewFileLocation;", "getLiquibaseVersion", "Lcom/intellij/util/text/SemVer;", "getSettingsLabels", "getSettingsContexts", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nLiquibaseSpringContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseSpringContextProvider.kt\ncom/intellij/liquibase/orm/provider/LiquibaseSpringContextProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1642#2,10:54\n1915#2:64\n1916#2:66\n1652#2:67\n1642#2,10:68\n1915#2:78\n1916#2:80\n1652#2:81\n1#3:65\n1#3:79\n*S KotlinDebug\n*F\n+ 1 LiquibaseSpringContextProvider.kt\ncom/intellij/liquibase/orm/provider/LiquibaseSpringContextProvider\n*L\n46#1:54,10\n46#1:64\n46#1:66\n46#1:67\n50#1:68,10\n50#1:78\n50#1:80\n50#1:81\n46#1:65\n50#1:79\n*E\n"})
public final class LiquibaseSpringContextProvider
implements LiquibaseFrameworkContextProvider {
    public boolean isLiquibaseSupported(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return LiquibaseHelper.isLiquibaseSupported$default(LiquibaseHelper.Companion.getInstance(project), project, false, 2, null);
    }

    @Nullable
    public VirtualFile findMainChangeLogFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LiquibaseManager liquibaseManager = LiquibaseManager.Companion.getInstance(project);
        VirtualFile virtualFile = liquibaseManager.findMainChangeLogFileBySpringProperty();
        if (virtualFile == null) {
            virtualFile = liquibaseManager.getSpringChangeLogFile("db/changelog/db.changelog-master.yaml");
        }
        return virtualFile;
    }

    @NotNull
    public List<String> changelogDirPatterns(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new String[]{StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(project).getState().getMainChangeLogDir(), (String)"/#", null, (int)2, null), StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(project).getState().getSecondaryChangeLogDir(), (String)"/#", null, (int)2, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<LocalQuickFix> createChangelogQuickFixes(@NotNull PsiElement element, @NotNull NewFileLocation location) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return CollectionsKt.listOf((Object)((Object)new CreateDiffChangelogQuickFix(element, location)));
    }

    @NotNull
    public SemVer getLiquibaseVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return LiquibaseCommandManager.Companion.getInstance(project).getLiquibaseVersion();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSettingsLabels(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$mapNotNull$iv = LiquibaseChangesConfig.Companion.getInstance(project).getLiquibaseChanges();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LiquibaseChange it = (LiquibaseChange)element$iv$iv;
            boolean bl2 = false;
            if (it.getLabels() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSettingsContexts(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$mapNotNull$iv = LiquibaseChangesConfig.Companion.getInstance(project).getLiquibaseChanges();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LiquibaseChange it = (LiquibaseChange)element$iv$iv;
            boolean bl2 = false;
            if (it.getContext() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

