/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests.execution;

import com.intellij.httpClient.grpc.restClient.execution.GrpcRequestIdentity;
import com.intellij.libraries.grpc.netty.shaded.NettyChannelProviderRegistrationService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentFactoryMap;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002RM\u0010\u0004\u001aA\u0012*\u0012( \n*\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t0\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/grpc/requests/execution/GrpcSharedChannelPool;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "channels", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequestIdentity;", "Lkotlin/ParameterName;", "name", "grpcRequestIdentity", "kotlin.jvm.PlatformType", "Lio/grpc/ManagedChannel;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "getOrCreateChannel", "createChannel", "createWithJdkSslProvider", "channelBuilder", "Lkotlin/Function1;", "disposeChannel", "", "channel", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcSharedChannelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcSharedChannelPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1834#2,4:69\n23#3:73\n23#3:75\n1#4:74\n*S KotlinDebug\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcSharedChannelPool\n*L\n18#1:69,4\n19#1:73\n62#1:75\n*E\n"})
public final class GrpcSharedChannelPool
implements Disposable {
    @NotNull
    private final ConcurrentMap<GrpcRequestIdentity, ManagedChannel> channels;

    public GrpcSharedChannelPool() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> GrpcSharedChannelPool.channels$lambda$0((Function1)new Function1<GrpcRequestIdentity, ManagedChannel>((Object)this){

            public final ManagedChannel invoke(GrpcRequestIdentity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcSharedChannelPool.access$createChannel((GrpcSharedChannelPool)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.channels = concurrentMap;
    }

    public void dispose() {
        int n;
        Iterable $this$count$iv = this.channels.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ManagedChannel p0 = (ManagedChannel)element$iv;
                boolean bl = false;
                if (!this.disposeChannel(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        GrpcSharedChannelPool $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(count + " out of " + this.channels.size() + " channels were shutdown normally");
    }

    @NotNull
    public final ManagedChannel getOrCreateChannel(@NotNull GrpcRequestIdentity grpcRequestIdentity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)grpcRequestIdentity, (String)"grpcRequestIdentity");
        ManagedChannel cachedChannel = (ManagedChannel)this.channels.get(grpcRequestIdentity);
        boolean bl2 = bl = cachedChannel != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cached gRPC channel was 'null' but must be 'not null'";
            throw new AssertionError((Object)string);
        }
        ManagedChannel managedChannel = cachedChannel;
        Intrinsics.checkNotNull((Object)managedChannel);
        return managedChannel;
    }

    private final ManagedChannel createChannel(GrpcRequestIdentity grpcRequestIdentity) {
        return this.createWithJdkSslProvider(grpcRequestIdentity, (Function1<? super GrpcRequestIdentity, ? extends ManagedChannel>)((Function1)GrpcSharedChannelPool::createChannel$lambda$0));
    }

    private final ManagedChannel createWithJdkSslProvider(GrpcRequestIdentity grpcRequestIdentity, Function1<? super GrpcRequestIdentity, ? extends ManagedChannel> channelBuilder) {
        ManagedChannel managedChannel;
        boolean openSslAlreadyDisabled;
        String string = System.getProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl");
        boolean bl = openSslAlreadyDisabled = string != null ? Boolean.parseBoolean(string) : false;
        if (!openSslAlreadyDisabled) {
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "true");
            ManagedChannel channel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "false");
            managedChannel = channel;
        } else {
            managedChannel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
        }
        return managedChannel;
    }

    private final boolean disposeChannel(ManagedChannel channel) {
        if (!channel.isShutdown()) {
            channel.shutdown();
        }
        if (!channel.isTerminated()) {
            channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        if (!channel.isTerminated()) {
            channel.shutdownNow();
            GrpcSharedChannelPool $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Force gRPC channel '" + channel.authority() + "' shutdown");
        }
        return channel.isTerminated();
    }

    private static final ManagedChannel channels$lambda$0(Function1 $tmp0, Object p0) {
        return (ManagedChannel)$tmp0.invoke(p0);
    }

    private static final ManagedChannel createChannel$lambda$0(GrpcRequestIdentity requestIdentity) {
        ManagedChannelBuilder managedChannelBuilder;
        Intrinsics.checkNotNullParameter((Object)requestIdentity, (String)"requestIdentity");
        NettyChannelProviderRegistrationService.Companion.ensureChannelProviderRegistered();
        ManagedChannelBuilder $this$createChannel_u24lambda_u240_u240 = managedChannelBuilder = ManagedChannelBuilder.forAddress((String)requestIdentity.getHost(), (int)requestIdentity.getPort());
        boolean bl = false;
        ManagedChannelBuilder managedChannelBuilder2 = requestIdentity.getSecureConnection() ? $this$createChannel_u24lambda_u240_u240.useTransportSecurity() : $this$createChannel_u24lambda_u240_u240.usePlaintext();
        ManagedChannel managedChannel = managedChannelBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        return managedChannel;
    }

    public static final /* synthetic */ ManagedChannel access$createChannel(GrpcSharedChannelPool $this, GrpcRequestIdentity grpcRequestIdentity) {
        return $this.createChannel(grpcRequestIdentity);
    }
}

