/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.protobuf.jvm.names.JavaNameGenerator;
import com.intellij.protobuf.jvm.names.Proto2DefinitionClassNames;
import com.intellij.protobuf.jvm.names.Proto2NameGenerator;
import com.intellij.protobuf.lang.names.NameGeneratorContributor;
import com.intellij.protobuf.lang.names.NameGeneratorUtils;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbOptionExpression;

public final class NameGeneratorSelector {
    private static final Logger log = Logger.getInstance(NameGeneratorSelector.class);

    private NameGeneratorSelector() {
    }

    private static Options parseOptions(PbFile file) {
        Options options = new Options();
        options.javaPackage = file.getPackageQualifiedName().toString();
        options.javaOuterClassname = Proto2DefinitionClassNames.getDefaultOuterClassName(file);
        for (PbOptionExpression optionExpression : file.getOptions()) {
            String optionName;
            switch (optionName = optionExpression.getOptionName().getText()) {
                case "java_package": {
                    NameGeneratorUtils.parseStringOption(optionExpression).ifPresent(s -> {
                        options.javaPackage = s;
                    });
                    break;
                }
                case "java_outer_classname": {
                    NameGeneratorUtils.parseStringOption(optionExpression).ifPresent(s -> {
                        options.javaOuterClassname = s;
                    });
                    break;
                }
                case "java_multiple_files": {
                    NameGeneratorUtils.parseBoolOption(optionExpression).ifPresent(b -> {
                        options.javaMultipleFiles = b;
                    });
                    break;
                }
            }
        }
        return options;
    }

    private static ImmutableList<JavaNameGenerator> contributeDefaultGenerators(PbFile file) {
        Options options = NameGeneratorSelector.parseOptions(file);
        return ImmutableList.of((Object)new Proto2NameGenerator(file, options.javaPackage, options.javaOuterClassname, options.javaMultipleFiles));
    }

    public static ImmutableList<JavaNameGenerator> selectForFile(PbFile file) {
        for (NameGeneratorContributor contributor : NameGeneratorContributor.EP_NAME.getExtensionList()) {
            if (!contributor.isApplicable(file)) continue;
            log.debug("NameSelector using " + contributor.getClass().getName() + " for protobuf name generators");
            return ImmutableList.copyOf(contributor.contributeGenerators(file, JavaNameGenerator.class));
        }
        return NameGeneratorSelector.contributeDefaultGenerators(file);
    }

    private static class Options {
        public String javaPackage;
        public String javaOuterClassname;
        public boolean javaMultipleFiles = false;

        private Options() {
        }
    }
}

