/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionClassMetaData;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnAction
implements PossiblyDumbAware,
ActionUpdateThreadAware {
    private static final Logger LOG = Logger.getInstance(AnAction.class);
    @ApiStatus.Internal
    public static final Key<Integer> ACTIONS_MOD_COUNT = Key.create((String)"AnAction.ACTIONS_MOD_COUNT");
    public static final Key<List<AnAction>> ACTIONS_KEY = Key.create((String)"AnAction.shortcutSet");
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    private Presentation myTemplatePresentation;
    @NotNull
    private ShortcutSet myShortcutSet;
    private boolean myIsDefaultIcon;
    private SmartFMap<String, Supplier<String>> myActionTextOverrides;
    private List<Supplier<@Nls String>> mySynonyms;
    @ApiStatus.Internal
    int myMetaFlags;

    public AnAction() {
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
    }

    public AnAction(@Nullable Icon icon) {
        this(Presentation.NULL_STRING, Presentation.NULL_STRING, icon);
    }

    public AnAction(@Nullable @NlsActions.ActionText String text2) {
        this(text2, null, null);
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(0);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(dynamicText);
        presentation.setDescription(Presentation.NULL_STRING);
        presentation.setIconSupplier(null);
    }

    public AnAction(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        this(text2 == null ? Presentation.NULL_STRING : () -> text2, description == null ? Presentation.NULL_STRING : () -> description, icon);
    }

    @ApiStatus.Experimental
    public AnAction(@NotNull @NlsActions.ActionText Supplier<String> text2, @Nullable @NlsActions.ActionDescription Supplier<String> description, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon) {
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(1);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text2);
        if (description != null) {
            presentation.setDescription(description);
        }
        presentation.setIconSupplier(icon);
    }

    @ApiStatus.Experimental
    public AnAction(@NotNull @NlsActions.ActionText Supplier<String> text2, @NotNull @NlsActions.ActionDescription Supplier<String> description) {
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(2);
        }
        if (description == null) {
            AnAction.$$$reportNull$$$0(3);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text2);
        presentation.setDescription(description);
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @Nullable Icon icon) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(4);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(dynamicText);
        if (icon != null) {
            presentation.setIcon(icon);
        }
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, @Nullable Icon icon) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(5);
        }
        if (dynamicDescription == null) {
            AnAction.$$$reportNull$$$0(6);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(dynamicText);
        presentation.setDescription(dynamicDescription);
        if (icon != null) {
            presentation.setIcon(icon);
        }
    }

    public boolean isDumbAware() {
        if (super.isDumbAware()) {
            return true;
        }
        return ActionClassMetaData.isDefaultUpdate(this);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        if (this instanceof UpdateInBackground && ((UpdateInBackground)((Object)this)).isUpdateInBackground()) {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AnAction.$$$reportNull$$$0(7);
            }
            return actionUpdateThread;
        }
        if (ActionClassMetaData.isDefaultUpdate(this)) {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AnAction.$$$reportNull$$$0(8);
            }
            return actionUpdateThread;
        }
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AnAction.$$$reportNull$$$0(9);
        }
        return actionUpdateThread;
    }

    @NotNull
    public final ShortcutSet getShortcutSet() {
        ShortcutSet shortcutSet = this.myShortcutSet;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(10);
        }
        return shortcutSet;
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(11);
        }
        this.registerCustomShortcutSet(shortcutSet, component, null);
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers, @Nullable JComponent component) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers)), component);
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(12);
        }
        this.setShortcutSet(shortcutSet);
        this.registerCustomShortcutSet(component, parentDisposable);
    }

    public final void registerCustomShortcutSet(@Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (component == null) {
            return;
        }
        List actionList = (List)ComponentUtil.getClientProperty((JComponent)component, ACTIONS_KEY);
        if (actionList == null) {
            CopyOnWriteArrayList value = new CopyOnWriteArrayList();
            ComponentUtil.putClientProperty((JComponent)component, ACTIONS_KEY, value);
            actionList = Objects.requireNonNullElse((List)ComponentUtil.getClientProperty((JComponent)component, ACTIONS_KEY), value);
        }
        if (!actionList.contains(this)) {
            actionList.add(this);
            AnAction.updateCustomActionsModCount(component);
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.unregisterCustomShortcutSet(component));
        }
    }

    public final void unregisterCustomShortcutSet(@NotNull JComponent component) {
        List actionList;
        if (component == null) {
            AnAction.$$$reportNull$$$0(13);
        }
        if ((actionList = (List)ComponentUtil.getClientProperty((JComponent)component, ACTIONS_KEY)) != null && actionList.remove(this)) {
            AnAction.updateCustomActionsModCount(component);
        }
    }

    private static void updateCustomActionsModCount(@NotNull JComponent component) {
        if (component == null) {
            AnAction.$$$reportNull$$$0(14);
        }
        int oldCounter = Objects.requireNonNullElse((Integer)ClientProperty.get((Component)component, ACTIONS_MOD_COUNT), 0);
        ClientProperty.put((JComponent)component, ACTIONS_MOD_COUNT, (Object)(oldCounter + 1));
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(15);
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        boolean allFlags = this instanceof ActionGroup && sourceAction instanceof ActionGroup;
        presentation.copyFrom(sourcePresentation, null, allFlags);
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(16);
        }
        this.setShortcutSet(sourceAction.getShortcutSet());
    }

    public final boolean isEnabledInModalContext() {
        return this.getTemplatePresentation().isEnabledInModalContext();
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.getTemplatePresentation().setEnabledInModalContext(enabledInModalContext);
    }

    @Deprecated(forRemoval=true)
    public boolean displayTextInToolbar() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public boolean useSmallerFontForTextInToolbar() {
        return false;
    }

    @ApiStatus.OverrideOnly
    @RequiresReadLock(generateAssertion=false)
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(17);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.OverrideOnly
    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(18);
        }
    }

    @NotNull
    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            presentation = this.createTemplatePresentation();
            LOG.assertTrue(presentation.isTemplate(), (Object)"Not a template presentation");
            this.myTemplatePresentation = presentation;
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            AnAction.$$$reportNull$$$0(19);
        }
        return presentation2;
    }

    @NotNull
    @ApiStatus.Internal
    public Presentation createTemplatePresentation() {
        Presentation presentation = Presentation.newTemplatePresentation();
        if (this.displayTextInToolbar()) {
            presentation.putClientProperty("SHOW_TEXT_IN_TOOLBAR", (Object)true);
            if (this.useSmallerFontForTextInToolbar()) {
                presentation.putClientProperty("USE_SMALL_FONT_IN_TOOLBAR", (Object)true);
            }
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            AnAction.$$$reportNull$$$0(20);
        }
        return presentation2;
    }

    @NlsActions.ActionText
    public final String getTemplateText() {
        return this.getTemplatePresentation().getText();
    }

    @ApiStatus.OverrideOnly
    public abstract void actionPerformed(@NotNull AnActionEvent var1);

    @ApiStatus.Internal
    public void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
        ActionManager actionManager;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(21);
        }
        if (this.myShortcutSet != shortcutSet && this.myShortcutSet != CustomShortcutSet.EMPTY && LoadingState.PROJECT_OPENED.isOccurred() && (actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) != null && actionManager.getId(this) != null) {
            LOG.warn((Throwable)PluginException.createByClass((String)("ShortcutSet of global AnActions should not be changed outside of KeymapManager.\nThis is likely not what you wanted to do. Consider setting shortcut in keymap defaults, inheriting from other action using `use-shortcut-of` or wrapping with ActionUtil.wrap(). Action: " + String.valueOf(this)), null, this.getClass()));
        }
        this.myShortcutSet = shortcutSet;
    }

    @ApiStatus.Internal
    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    @ApiStatus.Internal
    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.getTemplatePresentation().setPreferInjectedPsi(worksInInjected);
    }

    public boolean isInInjectedContext() {
        return this.getTemplatePresentation().isPreferInjectedPsi();
    }

    public void addTextOverride(@NotNull String place, @NotNull String text2) {
        if (place == null) {
            AnAction.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(23);
        }
        this.addTextOverride(place, () -> text2);
    }

    public void addTextOverride(@NotNull String place, @NotNull Supplier<String> text2) {
        if (place == null) {
            AnAction.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(25);
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)place, text2);
    }

    @ApiStatus.Internal
    public void copyActionTextOverride(@NotNull String fromPlace, @NotNull String toPlace, String id) {
        Supplier value;
        if (fromPlace == null) {
            AnAction.$$$reportNull$$$0(26);
        }
        if (toPlace == null) {
            AnAction.$$$reportNull$$$0(27);
        }
        if ((value = (Supplier)this.myActionTextOverrides.get((Object)fromPlace)) == null) {
            LOG.error((Throwable)PluginException.createByClass((String)("Missing override-text for action id: " + id + ", use-text-of-place: " + fromPlace), null, this.getClass()));
            return;
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus((Object)toPlace, (Object)value);
    }

    @ApiStatus.Internal
    public void applyTextOverride(@NotNull AnActionEvent event) {
        if (event == null) {
            AnAction.$$$reportNull$$$0(28);
        }
        this.applyTextOverride(event.getPlace(), event.getPresentation());
    }

    @ApiStatus.Internal
    public void applyTextOverride(@NotNull String place, @NotNull Presentation presentation) {
        Supplier override;
        if (place == null) {
            AnAction.$$$reportNull$$$0(29);
        }
        if (presentation == null) {
            AnAction.$$$reportNull$$$0(30);
        }
        if ((override = (Supplier)this.myActionTextOverrides.get((Object)place)) != null) {
            presentation.setText(override);
        }
    }

    @ApiStatus.Internal
    protected void copyActionTextOverrides(AnAction targetAction) {
        for (String place : this.myActionTextOverrides.keySet()) {
            targetAction.addTextOverride(place, Objects.requireNonNull((Supplier)this.myActionTextOverrides.get((Object)place)));
        }
    }

    public void addSynonym(@NotNull Supplier<@Nls String> text2) {
        if (text2 == null) {
            AnAction.$$$reportNull$$$0(31);
        }
        if (this.mySynonyms == Collections.emptyList()) {
            this.mySynonyms = new SmartList(text2);
        } else {
            this.mySynonyms.add(text2);
        }
    }

    public @NotNull List<Supplier<@Nls String>> getSynonyms() {
        List<Supplier<String>> list2 = this.mySynonyms;
        if (list2 == null) {
            AnAction.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @Nullable
    public static Project getEventProject(@Nullable AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    @NonNls
    public String toString() {
        Presentation p = this.getTemplatePresentation();
        return p.getText() + " (" + p.getDescription() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 19, 20, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPlace";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPlace";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutSet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatePresentation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynonyms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 32: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomShortcutSet";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomShortcutSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateCustomActionsModCount";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyShortcutFrom";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setShortcutSet";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addTextOverride";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyActionTextOverride";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyTextOverride";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addSynonym";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 19, 20, 32 -> new IllegalStateException(string);
        };
    }
}

