/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SlowOperations;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighterFactory;", "<init>", "()V", "createEditorHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "highlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "settings", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorColorScheme", "fileName", "", "intellij.platform.editor.ex"})
@SourceDebugExtension(value={"SMAP\nEditorHighlighterFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorHighlighterFactoryImpl.kt\ncom/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n23#2:80\n*S KotlinDebug\n*F\n+ 1 EditorHighlighterFactoryImpl.kt\ncom/intellij/openapi/editor/highlighter/EditorHighlighterFactoryImpl\n*L\n59#1:80\n*E\n"})
public final class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@Nullable SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            syntaxHighlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter(syntaxHighlighter, colors);
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (fileType instanceof LanguageFileType) {
            EditorHighlighter editorHighlighter = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.getInstance().forFileType(fileType)).getEditorHighlighter(project, fileType, null, settings);
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getEditorHighlighter(...)");
            return editorHighlighter;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, null);
        return this.createEditorHighlighter(highlighter, settings);
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return this.createEditorHighlighter(fileType, editorColorsScheme, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile file, @NotNull EditorColorsScheme editorColorScheme, @Nullable Project project) {
        block11: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editorColorScheme, (String)"editorColorScheme");
                v0 = file.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFileType(...)");
                fileType = v0;
                if (!(fileType instanceof LanguageFileType)) break block11;
                v1 = project;
                substLang = v1 == null ? null : LanguageUtil.getLanguageForPsi((Project)v1, (VirtualFile)file, (FileType)fileType);
                v2 = substFileType = substLang != null && substLang != ((LanguageFileType)fileType).getLanguage() ? substLang.getAssociatedFileType() : null;
                if (substFileType == null) break block12;
                provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.getInstance().forFileType((FileType)substFileType);
                editorHighlighter = provider.getEditorHighlighter(project, (FileType)substFileType, file, editorColorScheme);
                if (!Intrinsics.areEqual(editorHighlighter.getClass(), LexerEditorHighlighter.class)) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)editorHighlighter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.util.LexerEditorHighlighter");
                if (((LexerEditorHighlighter)editorHighlighter).isPlain()) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = isPlain = false;
                }
                if (!isPlain) {
                    Intrinsics.checkNotNull((Object)editorHighlighter);
                    return editorHighlighter;
                }
            }
            try {
                provider = (AutoCloseable)SlowOperations.knownIssue((String)"IDEA-333907, EA-821093");
                editorHighlighter = null;
                try {
                    it = (AccessToken)provider;
                    $i$a$-use-EditorHighlighterFactoryImpl$createEditorHighlighter$1 = false;
                    v4 = ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.getInstance().forFileType(fileType)).getEditorHighlighter(project, fileType, file, editorColorScheme);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getEditorHighlighter(...)");
                    var11_16 = v4;
                    return var11_16;
                }
                catch (Throwable var10_14) {
                    editorHighlighter = var10_14;
                    throw var10_14;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)provider, (Throwable)editorHighlighter);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                v5 = Logger.getInstance(EditorHighlighterFactoryImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                v5.error((Throwable)e);
            }
        }
        highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, file);
        return this.createEditorHighlighter(highlighter, editorColorScheme);
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return this.createEditorHighlighter(file, editorColorsScheme, project);
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return this.createEditorHighlighter(editorColorsScheme, fileName, project);
    }

    @Override
    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings, project);
    }
}

