/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database;

import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSource;
import com.intellij.persistence.database.ConfigDataSourceCandidate;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceService;
import com.intellij.persistence.database.ConfigExistingDataSource;
import com.intellij.persistence.database.ConfigNewDataSource;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.persistence.database.RecognizedDataSourceConfigProvider;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0016J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "T", "Lcom/intellij/persistence/database/DataSourceConfigType;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "", "getProvider", "Lcom/intellij/persistence/database/RecognizedDataSourceConfigProvider;", "configType", "(Lcom/intellij/persistence/database/DataSourceConfigType;)Lcom/intellij/persistence/database/RecognizedDataSourceConfigProvider;", "provideDataSources", "", "Lcom/intellij/persistence/database/ConfigDataSource;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "candidate", "Lcom/intellij/persistence/database/ConfigDataSourceCandidate;", "retrieveConfigs", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "intellij.javaee.persistence"})
@SourceDebugExtension(value={"SMAP\nDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceConfigProvider.kt\ncom/intellij/persistence/database/ConfigDataSourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1586#2:48\n1661#2,3:49\n*S KotlinDebug\n*F\n+ 1 DataSourceConfigProvider.kt\ncom/intellij/persistence/database/ConfigDataSourceProvider\n*L\n22#1:48\n22#1:49,3\n*E\n"})
public interface ConfigDataSourceProvider<T extends DataSourceConfigType, I extends ConfigDataSourcePropertyInfo> {
    @NotNull
    public RecognizedDataSourceConfigProvider<I> getProvider(@NotNull T var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<ConfigDataSource> provideDataSources(@NotNull ConfigurationFileInfo fileInfo, @NotNull ConfigDataSourceCandidate<T, I> candidate) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        List<RecognizedDatabaseConfig> configs = this.retrieveConfigs(fileInfo, candidate);
        Project project = fileInfo.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        RecognizedDataSourceConfigProvider<I> provider = this.getProvider(candidate.getConfigType());
        Iterable $this$map$iv = configs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration;
            RecognizedDatabaseConfig recognizedDatabaseConfig = (RecognizedDatabaseConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DbDataSource existingDatasource = ConfigDataSourceService.Companion.getInstance().findExistingDatasource(configuration.getUrl(), project2, provider);
            collection.add(existingDatasource != null ? (ConfigDataSource)new ConfigExistingDataSource(existingDatasource) : (ConfigDataSource)new ConfigNewDataSource(fileInfo, (RecognizedDatabaseConfig)configuration));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    default public List<RecognizedDatabaseConfig> retrieveConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull ConfigDataSourceCandidate<T, I> candidate) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        return this.getProvider(candidate.getConfigType()).getConfigs(fileInfo, candidate.getInfo());
    }
}

