/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.persistence.mongodb.json.surroundWith.MongoDBJsonWithArrayLiteralSurrounder;
import com.intellij.persistence.mongodb.json.surroundWith.MongoDBJsonWithObjectLiteralSurrounder;
import com.intellij.persistence.mongodb.json.surroundWith.MongoDBJsonWithQuotesSurrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J;\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\"\b\b\u0000\u0010\u0015*\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u0002H\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonSurroundDescriptor;", "Lcom/intellij/lang/surroundWith/SurroundDescriptor;", "<init>", "()V", "surrounders", "", "Lcom/intellij/lang/surroundWith/Surrounder;", "[Lcom/intellij/lang/surroundWith/Surrounder;", "getElementsToSurround", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "startOffset", "", "endOffset", "(Lcom/intellij/psi/PsiFile;II)[Lcom/intellij/psi/PsiElement;", "getSurrounders", "()[Lcom/intellij/lang/surroundWith/Surrounder;", "isExclusive", "", "collectElements", "T", "property", "kind", "Ljava/lang/Class;", "(ILcom/intellij/psi/PsiElement;Ljava/lang/Class;)[Lcom/intellij/psi/PsiElement;", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nMongoDBJsonSurroundDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDBJsonSurroundDescriptor.kt\ncom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonSurroundDescriptor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,67:1\n37#2,2:68\n*S KotlinDebug\n*F\n+ 1 MongoDBJsonSurroundDescriptor.kt\ncom/intellij/persistence/mongodb/json/surroundWith/MongoDBJsonSurroundDescriptor\n*L\n65#1:68,2\n*E\n"})
public final class MongoDBJsonSurroundDescriptor
implements SurroundDescriptor {
    @NotNull
    private final Surrounder[] surrounders;

    public MongoDBJsonSurroundDescriptor() {
        Surrounder[] surrounderArray = new Surrounder[]{new MongoDBJsonWithObjectLiteralSurrounder(), new MongoDBJsonWithArrayLiteralSurrounder(), new MongoDBJsonWithQuotesSurrounder()};
        this.surrounders = surrounderArray;
    }

    @NotNull
    public PsiElement[] getElementsToSurround(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement[] psiElementArray;
        MongoDBJsonProperty property;
        PsiElement firstElement;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int selectionStartOffset = startOffset;
        int selectionEndOffset = endOffset;
        PsiElement lastElement = file.findElementAt(selectionEndOffset - 1);
        for (firstElement = file.findElementAt(selectionStartOffset); firstElement != null && (firstElement instanceof PsiWhiteSpace || firstElement.getNode().getElementType() == MongoDBJsonElementTypes.COMMA); firstElement = firstElement.getNextSibling()) {
        }
        while (lastElement != null && (lastElement instanceof PsiWhiteSpace || lastElement.getNode().getElementType() == MongoDBJsonElementTypes.COMMA)) {
            lastElement = lastElement.getPrevSibling();
        }
        if (firstElement != null) {
            selectionStartOffset = firstElement.getTextRange().getStartOffset();
        }
        if (lastElement != null) {
            selectionEndOffset = lastElement.getTextRange().getEndOffset();
        }
        if ((property = (MongoDBJsonProperty)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)selectionStartOffset, (int)selectionEndOffset, MongoDBJsonProperty.class)) != null) {
            return this.collectElements(selectionEndOffset, (PsiElement)property, MongoDBJsonProperty.class);
        }
        MongoDBJsonValue value = (MongoDBJsonValue)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)selectionStartOffset, (int)selectionEndOffset, MongoDBJsonValue.class);
        if (value != null) {
            psiElementArray = this.collectElements(selectionEndOffset, (PsiElement)value, MongoDBJsonValue.class);
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        return this.surrounders;
    }

    public boolean isExclusive() {
        return false;
    }

    private final <T extends PsiElement> PsiElement[] collectElements(int endOffset, T property, Class<T> kind) {
        Object[] objectArray = new PsiElement[]{property};
        List properties = CollectionsKt.mutableListOf((Object[])objectArray);
        for (PsiElement nextSibling = property.getNextSibling(); nextSibling != null && nextSibling.getTextRange().getEndOffset() <= endOffset; nextSibling = nextSibling.getNextSibling()) {
            if (!kind.isInstance(nextSibling)) continue;
            T t = kind.cast(nextSibling);
            Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
            properties.add(t);
        }
        Collection $this$toTypedArray$iv = properties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiElement[0]);
    }
}

