/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\b\u0010\u0006\u001a\u00020\u0004H\u0000\u00a8\u0006\u0007"}, d2={"execCmd", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "", "", "getSshHostAddress", "getUserName", "intellij.platform.remoteController.backend"})
public final class UnattendedHostLinkKt {
    private static final ProcessOutput execCmd(List<String> cmd) {
        if (SystemInfo.isWindows) {
            throw new IllegalStateException("Running on Windows".toString());
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(cmd);
            int timeoutMs = 3000;
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)timeoutMs);
            if (output.isTimeout()) {
                throw new IllegalStateException(("'" + commandLine + "' execution timed out in " + timeoutMs + " ms").toString());
            }
            return output;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(("Exception while executing cmd: '" + StringUtil.join((Collection)cmd, (String)" ") + "', error: " + e.getMessage()).toString());
        }
    }

    @NotNull
    public static final String getSshHostAddress() {
        Object[] objectArray = new String[]{"uname", "-n"};
        ProcessOutput cmdOutput = UnattendedHostLinkKt.execCmd(CollectionsKt.listOf((Object[])objectArray));
        if (cmdOutput.getExitCode() != 0) {
            throw new IllegalStateException(("Failed to get hostname. Stderr: '" + cmdOutput.getStderr() + "'").toString());
        }
        String string = cmdOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public static final String getUserName() {
        ProcessOutput cmdOutput = UnattendedHostLinkKt.execCmd(CollectionsKt.listOf((Object)"whoami"));
        if (cmdOutput.getExitCode() != 0) {
            throw new IllegalStateException(("Failed to get username. Stderr: '" + cmdOutput.getStderr() + "'").toString());
        }
        String string = cmdOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }
}

