/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.metrics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.Metric;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricType;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricsStatus;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.providers.MetricProvider;
import com.jetbrains.rdserver.unattendedHost.metrics.DiskMetricsProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\b\u0004*\u0001\u0011\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/DiskMetricsProvider;", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/providers/MetricProvider;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "getMetrics", "", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/Metric;", "diskMetric", "status", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;", "value", "", "diskPercentageMetric", "com/jetbrains/rdserver/unattendedHost/metrics/DiskMetricsProvider$diskPercentageMetric$1", "(Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;D)Lcom/jetbrains/rdserver/unattendedHost/metrics/DiskMetricsProvider$diskPercentageMetric$1;", "Companion", "intellij.platform.remoteController.backend"})
public final class DiskMetricsProvider
implements MetricProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String TOTAL_DISK_SPACE_GB = "totalDiskSpaceGb";
    @NotNull
    public static final String USED_DISK_SPACE_GB = "usedDiskSpaceGb";
    @NotNull
    public static final String USED_DISK_SPACE_PERCENTAGE = "usedDiskSpacePercentage";
    private static final long gbCoefficient = 0x40000000L;

    public DiskMetricsProvider() {
        this.id = "diskMetrics";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Map<String, Metric> getMetrics() {
        LOG.trace("Updating disk data");
        File home = new File(SystemProperties.getUserHome());
        double total = (double)home.getTotalSpace() / 1.073741824E9;
        double free = (double)home.getFreeSpace() / 1.073741824E9;
        double percentageForDisk = (double)100 * (total - free) / total;
        Metric totalMetric = this.diskMetric(MetricsStatus.NORMAL, total);
        Metric usedMetric = this.diskMetric(MetricsStatus.NORMAL, total - free);
        diskPercentageMetric.1 usedPercentageMetric = this.diskPercentageMetric(MetricProvider.Companion.calculateMetricStatus((Comparable)Double.valueOf(percentageForDisk), (Comparable)Double.valueOf(80.0), (Comparable)Double.valueOf(95.0)), percentageForDisk);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TOTAL_DISK_SPACE_GB, (Object)totalMetric), TuplesKt.to((Object)USED_DISK_SPACE_GB, (Object)usedMetric), TuplesKt.to((Object)USED_DISK_SPACE_PERCENTAGE, (Object)((Object)usedPercentageMetric))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Metric diskMetric(MetricsStatus status, double value) {
        return new Metric(MetricType.PERFORMANCE, status, (Object)value);
    }

    private final diskPercentageMetric.1 diskPercentageMetric(MetricsStatus status, double value) {
        MetricType metricType = MetricType.PERFORMANCE;
        return new Metric(status, value, metricType){

            public String toString() {
                if (this.getStatusProperty().getValue() == MetricsStatus.DANGER) {
                    Object[] objectArray = new Object[1];
                    String string = "%.0f";
                    Object[] objectArray2 = new Object[]{this.getValueProperty().getValue()};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
                    return PlatformSplitBundle.INSTANCE.message("metrics.disk.full.label", objectArray);
                }
                Object[] objectArray = new Object[1];
                String string = "%.0f";
                Object[] objectArray3 = new Object[]{this.getValueProperty().getValue()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                return PlatformSplitBundle.INSTANCE.message("metrics.disk.label", objectArray);
            }
        };
    }

    static {
        Logger logger = Logger.getInstance(DiskMetricsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/DiskMetricsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TOTAL_DISK_SPACE_GB", "", "USED_DISK_SPACE_GB", "USED_DISK_SPACE_PERCENTAGE", "gbCoefficient", "", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

