/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.actions.DataKeysKt;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.DependencyKt;
import com.intellij.packageChecker.model.ForwardDependenciesBuilderResolver;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.model.SourcedDependency;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.packageChecker.toolwindow.controller.PackageCheckerViewService;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/actions/FindUsagesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "supportedPackageTypes", "", "Lcom/intellij/packageChecker/model/PackageType;", "sourcedDependencies", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "runFindTask", "project", "Lcom/intellij/openapi/project/Project;", "moduleToDependencies", "", "Lcom/intellij/openapi/module/Module;", "", "Lcom/intellij/packageChecker/model/Dependency;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nFindUsagesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindUsagesAction.kt\ncom/intellij/packageChecker/actions/FindUsagesAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n1786#2,2:129\n1786#2,3:131\n1788#2:134\n1642#2,10:135\n1915#2:145\n1916#2:147\n1652#2:148\n1525#2:149\n1557#2,3:150\n1560#2,3:160\n1#3:146\n383#4,7:153\n*S KotlinDebug\n*F\n+ 1 FindUsagesAction.kt\ncom/intellij/packageChecker/actions/FindUsagesAction\n*L\n35#1:129,2\n42#1:131,3\n35#1:134\n60#1:135,10\n60#1:145\n60#1:147\n60#1:148\n63#1:149\n63#1:150,3\n63#1:160,3\n60#1:146\n63#1:153,7\n*E\n"})
public final class FindUsagesAction
extends AnAction {
    @NotNull
    private final Set<PackageType> supportedPackageTypes;
    @NotNull
    private final Set<PackageType> sourcedDependencies;

    public FindUsagesAction() {
        PackageType[] packageTypeArray = new PackageType[]{PackageType.maven, PackageType.npm, PackageType.pypi};
        this.supportedPackageTypes = SetsKt.setOf((Object[])packageTypeArray);
        packageTypeArray = new PackageType[]{PackageType.npm, PackageType.pypi};
        this.sourcedDependencies = SetsKt.setOf((Object[])packageTypeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Presentation presentation;
        block6: {
            boolean bl2;
            Iterable iterable;
            block8: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(false);
                if (e.getProject() == null) return;
                Project project = e.getProject();
                Intrinsics.checkNotNull((Object)project);
                if (project.isDisposed()) {
                    return;
                }
                List dependencies = (List)e.getData(DataKeysKt.getDEPENDENCY_LIST());
                Collection collection = dependencies;
                if (collection == null) return;
                if (collection.isEmpty()) {
                    return;
                }
                boolean bl3 = false;
                if (bl3) {
                    return;
                }
                iterable = dependencies;
                presentation = e.getPresentation();
                boolean $i$f$all = false;
                if (!(iterable instanceof Collection) || !((Collection)iterable).isEmpty()) break block8;
                bl = true;
                break block6;
            }
            Iterator iterator = iterable.iterator();
            do {
                block12: {
                    boolean bl4;
                    block7: {
                        Iterator iterator2;
                        block14: {
                            block9: {
                                boolean isValid;
                                block10: {
                                    block11: {
                                        Iterable $this$all$iv;
                                        block13: {
                                            if (!iterator.hasNext()) break block9;
                                            Object element$iv = iterator.next();
                                            Dependency it = (Dependency)element$iv;
                                            boolean bl5 = false;
                                            PackageType packageType = it.getPkg().getType();
                                            DependencyContext dependencyContext = it.getContext();
                                            boolean bl6 = isValid = (dependencyContext != null ? dependencyContext.getModule() : null) != null && this.supportedPackageTypes.contains((Object)packageType);
                                            if (!this.sourcedDependencies.contains((Object)packageType)) break block10;
                                            if (!(it instanceof SourcedDependency)) break block11;
                                            if (!isValid || !(!((Collection)((SourcedDependency)it).getSourceDirectories()).isEmpty())) break block12;
                                            $this$all$iv = ((SourcedDependency)it).getSourceDirectories();
                                            boolean $i$f$all = false;
                                            if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block13;
                                            bl4 = true;
                                            break block7;
                                        }
                                        iterator2 = $this$all$iv.iterator();
                                        break block14;
                                    }
                                    bl2 = false;
                                    continue;
                                }
                                bl2 = isValid;
                                continue;
                            }
                            bl = true;
                            break block6;
                        }
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl7 = false;
                            if (it.isValid() && it.isDirectory()) continue;
                            bl4 = false;
                            break block7;
                        }
                        bl4 = true;
                    }
                    if (bl4) {
                        bl2 = true;
                        continue;
                    }
                }
                bl2 = false;
            } while (bl2);
            bl = false;
        }
        boolean bl8 = bl;
        presentation.setEnabledAndVisible(bl8);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list = (List)e.getData(DataKeysKt.getDEPENDENCY_LIST());
        if (list == null) {
            return;
        }
        List chosenDependencies = list;
        Iterable iterable = chosenDependencies;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Dependency it = (Dependency)element$iv$iv;
            boolean bl2 = false;
            DependencyContext dependencyContext = it.getContext();
            if (dependencyContext == null || (dependencyContext = dependencyContext.getModule()) == null) {
                pair = null;
            } else {
                DependencyContext module = dependencyContext;
                pair = TuplesKt.to((Object)module, (Object)it);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-FindUsagesAction$actionPerformed$forwardDependenciesBuilderList$42 = false;
            Module key$iv$iv = (Module)it2.getFirst();
            Object bl = destination$iv$iv;
            Module key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-FindUsagesAction$actionPerformed$forwardDependenciesBuilderList$42 = (Pair)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl5 = false;
            list2.add((Dependency)it.getSecond());
        }
        Object forwardDependenciesBuilderList = destination$iv$iv;
        this.runFindTask(project2, (Map<Module, ? extends List<? extends Dependency>>)forwardDependenciesBuilderList);
    }

    private final void runFindTask(Project project, Map<Module, ? extends List<? extends Dependency>> moduleToDependencies) {
        String string = PackageCheckerBundle.message("action.PCFindUsagesAction.task.text", new Object[0]);
        new Task.Backgroundable(project, moduleToDependencies, string){
            public List<? extends ForwardDependenciesBuilder> forwardDependenciesBuilders;
            public String findUsagesTitle;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<Module, List<Dependency>> $moduleToDependencies;
            {
                this.$project = $project;
                this.$moduleToDependencies = $moduleToDependencies;
                super($project, $super_call_param$1);
            }

            public final List<ForwardDependenciesBuilder> getForwardDependenciesBuilders() {
                List<ForwardDependenciesBuilder> list = this.forwardDependenciesBuilders;
                if (list != null) {
                    return list;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"forwardDependenciesBuilders");
                return null;
            }

            public final void setForwardDependenciesBuilders(List<? extends ForwardDependenciesBuilder> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.forwardDependenciesBuilders = list;
            }

            public final String getFindUsagesTitle() {
                String string = this.findUsagesTitle;
                if (string != null) {
                    return string;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"findUsagesTitle");
                return null;
            }

            public final void setFindUsagesTitle(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.findUsagesTitle = string;
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Object object;
                Object[] $this$mapTo$iv$iv;
                Object list$iv$iv;
                boolean bl;
                Iterable $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                indicator.setText2(PackageCheckerBundle.message("action.PCFindUsagesAction.indicator.looking.text", new Object[0]));
                Map<Module, List<Dependency>> map2 = this.$moduleToDependencies;
                Project project = this.$project;
                Object object2 = this;
                boolean $i$f$flatMap = false;
                void var5_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv;
                    void $this$groupByTo$iv$iv;
                    Map $this$groupBy$iv;
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    bl = false;
                    Module module = (Module)entry2.getKey();
                    List dependencies = (List)entry2.getValue();
                    ProgressManager.checkCanceled();
                    Iterable iterable = dependencies;
                    boolean $i$f$groupBy = false;
                    void var16_28 = $this$groupBy$iv;
                    Map destination$iv$iv2 = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv2 : $this$groupByTo$iv$iv) {
                        Object object3;
                        void $this$getOrPut$iv$iv$iv;
                        Dependency it = (Dependency)element$iv$iv2;
                        boolean bl2 = false;
                        PackageType key$iv$iv = it.getPkg().getType();
                        Map map3 = destination$iv$iv2;
                        PackageType key$iv$iv$iv = key$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)((Object)key$iv$iv$iv));
                        if (value$iv$iv$iv == null) {
                            boolean bl3 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                            object3 = answer$iv$iv$iv;
                        } else {
                            object3 = value$iv$iv$iv;
                        }
                        List list$iv$iv2 = (List)object3;
                        list$iv$iv2.add(element$iv$iv2);
                    }
                    $this$groupBy$iv = destination$iv$iv2;
                    boolean $i$f$map = false;
                    $this$groupByTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator<Object> iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry item$iv$iv;
                        Map.Entry entry3 = item$iv$iv = (Map.Entry)iterator2.next();
                        Collection collection = destination$iv$iv3;
                        boolean bl4 = false;
                        PackageType type = (PackageType)((Object)entry3.getKey());
                        List dependencies2 = (List)entry3.getValue();
                        ForwardDependenciesBuilderResolver resolver = ForwardDependenciesBuilderResolver.Companion.supportedResolver(project, type);
                        collection.add(resolver.resolve(project, module, dependencies2));
                    }
                    list$iv$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object2.setForwardDependenciesBuilders((List)destination$iv$iv);
                Object $this$map$iv = CollectionsKt.flatten((Iterable)this.$moduleToDependencies.values());
                boolean $i$f$map22 = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Map.Entry<K, V> entry : $this$mapTo$iv$iv) {
                    void it;
                    list$iv$iv = (Dependency)((Object)entry);
                    object2 = destination$iv$iv;
                    bl = false;
                    object2.add(DependencyKt.simplifiedCoordinates(it.getPkg()));
                }
                List dependencies = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                if (dependencies.size() == 1) {
                    Object[] $i$f$map22 = new Object[]{CollectionsKt.first((List)dependencies)};
                    $this$map$iv = PackageCheckerBundle.message("dependency.usages.panel.content.name", $i$f$map22);
                    Intrinsics.checkNotNull((Object)$this$map$iv);
                    object = $this$map$iv;
                } else {
                    String postfix = dependencies.size() > 3 ? "..." : "";
                    $this$mapTo$iv$iv = new Object[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)dependencies, (int)3), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + postfix};
                    $this$map$iv = PackageCheckerBundle.message("dependency.usages.panel.content.name", $this$mapTo$iv$iv);
                    Intrinsics.checkNotNull((Object)$this$map$iv);
                    object = $this$map$iv;
                }
                this.setFindUsagesTitle((String)object);
                Iterable $this$forEachIndexed$iv = this.getForwardDependenciesBuilders();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ForwardDependenciesBuilder forwardDependenciesBuilder = (ForwardDependenciesBuilder)item$iv;
                    int index = n;
                    bl = false;
                    indicator.setFraction((double)index / (double)this.getForwardDependenciesBuilders().size());
                    forwardDependenciesBuilder.analyze();
                }
            }

            public void onSuccess() {
                if (this.getForwardDependenciesBuilders().isEmpty()) {
                    PackageCheckerViewService packageCheckerViewService = PackageCheckerViewService.Companion.getInstance(this.$project);
                    String string = PackageCheckerBundle.message("action.PCFindUsagesAction.error.usages.notfound.text", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    packageCheckerViewService.showErrorNotification(string);
                    return;
                }
                PackageCheckerViewService.Companion.getInstance(this.$project).showUsages(this.getFindUsagesTitle(), this.getForwardDependenciesBuilders());
            }
        }.queue();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

