/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/packageChecker/go/GoNavigateToDependencyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "goModFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependencyImportPath", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getFamilyName", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoVulnerablePackageImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoVulnerablePackageImportInspection.kt\ncom/intellij/packageChecker/go/GoNavigateToDependencyQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
final class GoNavigateToDependencyQuickFix
implements LocalQuickFix {
    @NotNull
    private final VirtualFile goModFile;
    @NotNull
    private final String dependencyImportPath;

    public GoNavigateToDependencyQuickFix(@NotNull VirtualFile goModFile, @NotNull String dependencyImportPath) {
        Intrinsics.checkNotNullParameter((Object)goModFile, (String)"goModFile");
        Intrinsics.checkNotNullParameter((Object)dependencyImportPath, (String)"dependencyImportPath");
        this.goModFile = goModFile;
        this.dependencyImportPath = dependencyImportPath;
    }

    @NotNull
    public String getFamilyName() {
        String string = PackageCheckerBundle.message("inspection.navigate.to.dependency.declaration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.goModFile);
            VgoFile vgoFile = psiFile instanceof VgoFile ? (VgoFile)psiFile : null;
            if (vgoFile == null) {
                return;
            }
            VgoFile psiFile2 = vgoFile;
            Iterable iterable = UtilsKt.getDependencies((PsiFile)psiFile2);
            for (Object t : iterable) {
                VgoModuleSpec it = (VgoModuleSpec)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier().getText(), (Object)this.dependencyImportPath)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        VgoModuleSpec vgoModuleSpec = v1;
        if (vgoModuleSpec == null) {
            return;
        }
        VgoModuleSpec moduleSpec = vgoModuleSpec;
        PsiElement psiElement = moduleSpec.getModuleVersion();
        if (psiElement == null) {
            return;
        }
        PsiElement version = psiElement;
        new OpenFileDescriptor(project, this.goModFile, version.getTextOffset()).navigate(true);
    }
}

