/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.inspection.problemDescriptor.ProblemDescriptorsHolder;
import com.intellij.packageChecker.service.HeadlessSynchronizationService;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH&J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000fH\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/packageChecker/inspection/AbstractLocalLibrariesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "collectProblemDescriptors", "Lcom/intellij/packageChecker/inspection/problemDescriptor/ProblemDescriptorsHolder;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "service", "Lcom/intellij/packageChecker/service/PackageService;", "isHeadlessMode", "reportStatistics", "", "problemDescriptors", "intellij.packageChecker"})
public abstract class AbstractLocalLibrariesInspection
extends LocalInspectionTool {
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PackageService service = PackageService.Companion.getInstance(project2);
        if (!service.isBuildFile(file)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module2 = module;
        HeadlessSynchronizationService synchronizationService = HeadlessSynchronizationService.Companion.getInstance(project2);
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(synchronizationService, null){
            int label;
            final /* synthetic */ HeadlessSynchronizationService $synchronizationService;
            {
                this.$synchronizationService = $synchronizationService;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$synchronizationService.waitForCheckPackagesCompleted((Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean isHeadlessMode = synchronizationService.isHeadlessMode();
        ProblemDescriptorsHolder problemDescriptorsHolder = this.collectProblemDescriptors(file, project2, module2, service, isHeadlessMode);
        this.reportStatistics(project2, problemDescriptorsHolder);
        Collection collection = CollectionsKt.plus((Collection)problemDescriptorsHolder.getDirectProblemDescriptors(), (Iterable)problemDescriptorsHolder.getTransitiveProblemDescriptors());
        Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (ProblemDescriptor[])UtilKt.toArray((Collection)collection, (Object[])ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public abstract ProblemDescriptorsHolder collectProblemDescriptors(@NotNull PsiFile var1, @NotNull Project var2, @NotNull Module var3, @NotNull PackageService var4, boolean var5);

    protected void reportStatistics(@NotNull Project project, @NotNull ProblemDescriptorsHolder problemDescriptors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptors, (String)"problemDescriptors");
        PackageCheckerUsageStat.INSTANCE.getLocalInspectionResult().log(project, (Object)problemDescriptors.getDirectProblemDescriptors().size());
        PackageCheckerUsageStat.INSTANCE.getLocalInspectionTransitiveResult().log(project, (Object)problemDescriptors.getTransitiveProblemDescriptors().size());
    }
}

