/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H$J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeZoneAwareInterval;", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "()V", "addInterval", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "dateTime", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "atOrBefore", "range", "", "", "start", "end", "plot-base"})
public abstract class TimeZoneAwareInterval
implements TimeInterval {
    @NotNull
    protected abstract DateTime atOrBefore(@NotNull DateTime var1);

    @NotNull
    protected abstract DateTime addInterval(@NotNull DateTime var1, @NotNull TimeZone var2);

    @Override
    @NotNull
    public final List<Double> range(double start2, double end, @Nullable TimeZone tz) {
        if (start2 > end) {
            throw new RuntimeException("Duration must be positive");
        }
        TimeZone timeZone = tz;
        if (timeZone == null) {
            timeZone = TimeZone.Companion.getUTC();
        }
        TimeZone tz2 = timeZone;
        DateTime startDateTime = DateTime.Companion.ofEpochMilliseconds(start2, tz2);
        DateTime it = this.atOrBefore(startDateTime);
        boolean bl = false;
        DateTime nextDateTime = it.compareTo(startDateTime) < 0 ? this.addInterval(it, tz2) : it;
        ArrayList<Double> result2 = new ArrayList<Double>();
        double nextTick = nextDateTime.toEpochMilliseconds(tz2);
        while (nextTick <= end) {
            result2.add(nextTick);
            nextDateTime = this.addInterval(nextDateTime, tz2);
            nextTick = nextDateTime.toEpochMilliseconds(tz2);
        }
        return result2;
    }
}

